/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnnotationActions
extends PdfObjectWrapper<PdfDictionary>
implements Map<PdfName, Action> {
    private Annotation parent;

    public AnnotationActions(Annotation parent) {
        super(parent.getFile(), new PdfDictionary());
        this.parent = parent;
    }

    public AnnotationActions(Annotation parent, PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
        this.parent = parent;
    }

    @Override
    public AnnotationActions clone(Document context) {
        throw new NotImplementedException();
    }

    public Action getOnActivate() {
        return this.parent.getAction();
    }

    public Action getOnEnter() {
        PdfDirectObject onEnterObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.E);
        if (onEnterObject == null) {
            return null;
        }
        return Action.wrap(onEnterObject, this.getContainer());
    }

    public Action getOnExit() {
        PdfDirectObject onExitObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.X);
        if (onExitObject == null) {
            return null;
        }
        return Action.wrap(onExitObject, this.getContainer());
    }

    public Action getOnMouseDown() {
        PdfDirectObject onMouseDownObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
        if (onMouseDownObject == null) {
            return null;
        }
        return Action.wrap(onMouseDownObject, this.getContainer());
    }

    public Action getOnMouseUp() {
        PdfDirectObject onMouseUpObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.U);
        if (onMouseUpObject == null) {
            return null;
        }
        return Action.wrap(onMouseUpObject, this.getContainer());
    }

    public Action getOnPageClose() {
        PdfDirectObject onPageCloseObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.PC);
        if (onPageCloseObject == null) {
            return null;
        }
        return Action.wrap(onPageCloseObject, this.getContainer());
    }

    public Action getOnPageInvisible() {
        PdfDirectObject onPageInvisibleObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.PI);
        if (onPageInvisibleObject == null) {
            return null;
        }
        return Action.wrap(onPageInvisibleObject, this.getContainer());
    }

    public Action getOnPageOpen() {
        PdfDirectObject onPageOpenObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.PO);
        if (onPageOpenObject == null) {
            return null;
        }
        return Action.wrap(onPageOpenObject, this.getContainer());
    }

    public Action getOnPageVisible() {
        PdfDirectObject onPageVisibleObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.PV);
        if (onPageVisibleObject == null) {
            return null;
        }
        return Action.wrap(onPageVisibleObject, this.getContainer());
    }

    public void setOnActivate(Action value) {
        this.parent.setAction(value);
        this.parent.update();
    }

    public void setOnEnter(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.E, value.getBaseObject());
    }

    public void setOnExit(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.X, value.getBaseObject());
    }

    public void setOnMouseDown(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, value.getBaseObject());
    }

    public void setOnMouseUp(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.U, value.getBaseObject());
    }

    public void setOnPageClose(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PC, value.getBaseObject());
    }

    public void setOnPageInvisible(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PI, value.getBaseObject());
    }

    public void setOnPageOpen(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PO, value.getBaseObject());
    }

    public void setOnPageVisible(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PV, value.getBaseObject());
    }

    @Override
    public void clear() {
        ((PdfDictionary)this.getBaseDataObject()).clear();
        this.setOnActivate(null);
    }

    @Override
    public boolean containsKey(Object key) {
        return ((PdfDictionary)this.getBaseDataObject()).containsKey(key) || PdfName.A.equals(key) && ((PdfDictionary)this.parent.getBaseDataObject()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return value != null && (((PdfDictionary)this.getBaseDataObject()).containsValue(((Action)value).getBaseObject()) || value.equals(this.getOnActivate()));
    }

    @Override
    public Set<Map.Entry<PdfName, Action>> entrySet() {
        throw new NotImplementedException();
    }

    @Override
    public Action get(Object key) {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(key), this.getContainer());
    }

    @Override
    public boolean isEmpty() {
        return ((PdfDictionary)this.getBaseDataObject()).isEmpty() && this.getOnActivate() == null;
    }

    @Override
    public Set<PdfName> keySet() {
        HashSet<PdfName> keySet = new HashSet<PdfName>(((PdfDictionary)this.getBaseDataObject()).keySet());
        if (((PdfDictionary)this.parent.getBaseDataObject()).containsKey(PdfName.A)) {
            keySet.add(PdfName.A);
        }
        return this.keySet();
    }

    @Override
    public Action put(PdfName key, Action value) {
        return Action.wrap(value == null ? ((PdfDictionary)this.getBaseDataObject()).remove(key) : ((PdfDictionary)this.getBaseDataObject()).put(key, value.getBaseObject()), this.getContainer());
    }

    @Override
    public void putAll(Map<? extends PdfName, ? extends Action> entries) {
        throw new NotImplementedException();
    }

    @Override
    public Action remove(Object key) {
        Action oldValue;
        if (PdfName.A.equals(key)) {
            oldValue = this.getOnActivate();
            this.setOnActivate(null);
        } else {
            oldValue = Action.wrap(((PdfDictionary)this.getBaseDataObject()).remove(key), this.getContainer());
        }
        return oldValue;
    }

    @Override
    public int size() {
        return ((PdfDictionary)this.getBaseDataObject()).size() + (((PdfDictionary)this.parent.getBaseDataObject()).containsKey(PdfName.A) ? 1 : 0);
    }

    @Override
    public Collection<Action> values() {
        Collection<PdfDirectObject> objects = ((PdfDictionary)this.getBaseDataObject()).values();
        ArrayList<Action> values = new ArrayList<Action>(objects.size());
        for (PdfDirectObject object : objects) {
            values.add(Action.wrap(object, this.getContainer()));
        }
        Action action = this.getOnActivate();
        if (action != null) {
            values.add(action);
        }
        return values;
    }
}

