/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.annotations;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.documents.interaction.annotations.AnnotationActions;
import it.stefanochizzolini.clown.documents.interaction.annotations.Appearance;
import it.stefanochizzolini.clown.documents.interaction.annotations.Border;
import it.stefanochizzolini.clown.documents.interaction.annotations.CalloutNote;
import it.stefanochizzolini.clown.documents.interaction.annotations.Caret;
import it.stefanochizzolini.clown.documents.interaction.annotations.Ellipse;
import it.stefanochizzolini.clown.documents.interaction.annotations.FileAttachment;
import it.stefanochizzolini.clown.documents.interaction.annotations.Line;
import it.stefanochizzolini.clown.documents.interaction.annotations.Link;
import it.stefanochizzolini.clown.documents.interaction.annotations.MovieAnnotation;
import it.stefanochizzolini.clown.documents.interaction.annotations.Note;
import it.stefanochizzolini.clown.documents.interaction.annotations.Polygon;
import it.stefanochizzolini.clown.documents.interaction.annotations.Polyline;
import it.stefanochizzolini.clown.documents.interaction.annotations.Popup;
import it.stefanochizzolini.clown.documents.interaction.annotations.Rectangle;
import it.stefanochizzolini.clown.documents.interaction.annotations.RubberStamp;
import it.stefanochizzolini.clown.documents.interaction.annotations.Scribble;
import it.stefanochizzolini.clown.documents.interaction.annotations.SoundAnnotation;
import it.stefanochizzolini.clown.documents.interaction.annotations.TextMarkup;
import it.stefanochizzolini.clown.documents.interaction.annotations.Widget;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDate;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.EnumSet;

public class Annotation
extends PdfObjectWrapper<PdfDictionary> {
    public static final Annotation wrap(PdfReference reference) {
        return Annotation.wrap(reference, null);
    }

    public static final Annotation wrap(PdfDirectObject baseObject, PdfIndirectObject container) {
        if (baseObject == null) {
            return null;
        }
        PdfDictionary dataObject = (PdfDictionary)File.resolve(baseObject);
        if (!dataObject.get(PdfName.Type).equals(PdfName.Annot)) {
            return null;
        }
        PdfName annotationType = (PdfName)dataObject.get(PdfName.Subtype);
        if (annotationType.equals(PdfName.Text)) {
            return new Note(baseObject, container);
        }
        if (annotationType.equals(PdfName.Link)) {
            return new Link(baseObject, container);
        }
        if (annotationType.equals(PdfName.FreeText)) {
            return new CalloutNote(baseObject, container);
        }
        if (annotationType.equals(PdfName.Line)) {
            return new Line(baseObject, container);
        }
        if (annotationType.equals(PdfName.Square)) {
            return new Rectangle(baseObject, container);
        }
        if (annotationType.equals(PdfName.Circle)) {
            return new Ellipse(baseObject, container);
        }
        if (annotationType.equals(PdfName.Polygon)) {
            return new Polygon(baseObject, container);
        }
        if (annotationType.equals(PdfName.PolyLine)) {
            return new Polyline(baseObject, container);
        }
        if (annotationType.equals(PdfName.Highlight) || annotationType.equals(PdfName.Underline) || annotationType.equals(PdfName.Squiggly) || annotationType.equals(PdfName.StrikeOut)) {
            return new TextMarkup(baseObject, container);
        }
        if (annotationType.equals(PdfName.Stamp)) {
            return new RubberStamp(baseObject, container);
        }
        if (annotationType.equals(PdfName.Caret)) {
            return new Caret(baseObject, container);
        }
        if (annotationType.equals(PdfName.Ink)) {
            return new Scribble(baseObject, container);
        }
        if (annotationType.equals(PdfName.Popup)) {
            return new Popup(baseObject, container);
        }
        if (annotationType.equals(PdfName.FileAttachment)) {
            return new FileAttachment(baseObject, container);
        }
        if (annotationType.equals(PdfName.Sound)) {
            return new SoundAnnotation(baseObject, container);
        }
        if (annotationType.equals(PdfName.Movie)) {
            return new MovieAnnotation(baseObject, container);
        }
        if (annotationType.equals(PdfName.Widget)) {
            return new Widget(baseObject, container);
        }
        return new Annotation(baseObject, container);
    }

    protected Annotation(Document context, PdfName subtype, Rectangle2D box, Page page) {
        super(context.getFile(), new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.Subtype, PdfName.P, PdfName.Border}, new PdfDirectObject[]{PdfName.Annot, subtype, page.getBaseObject(), new PdfArray(new PdfInteger(0), new PdfInteger(0), new PdfInteger(0))}));
        this.setBox(box);
        PdfArray pageAnnotsObject = (PdfArray)File.resolve(((PdfDictionary)page.getBaseDataObject()).get(PdfName.Annots));
        if (pageAnnotsObject == null) {
            pageAnnotsObject = new PdfArray();
            ((PdfDictionary)page.getBaseDataObject()).put(PdfName.Annots, pageAnnotsObject);
        }
        pageAnnotsObject.add(this.getBaseObject());
    }

    protected Annotation(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Annotation clone(Document context) {
        throw new NotImplementedException();
    }

    public Action getAction() {
        PdfDirectObject actionObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
        if (actionObject == null) {
            return null;
        }
        return Action.wrap(actionObject, this.getContainer());
    }

    public AnnotationActions getActions() {
        PdfDirectObject actionsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA);
        if (actionsObject == null) {
            return null;
        }
        return new AnnotationActions(this, actionsObject, this.getContainer());
    }

    public Appearance getAppearance() {
        PdfDirectObject appearanceObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AP);
        if (appearanceObject == null) {
            return null;
        }
        return new Appearance(appearanceObject, this.getContainer());
    }

    public Border getBorder() {
        PdfDirectObject borderObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.BS);
        if (borderObject == null) {
            return null;
        }
        return new Border(borderObject, this.getContainer());
    }

    public Rectangle2D getBox() {
        it.stefanochizzolini.clown.objects.Rectangle box = new it.stefanochizzolini.clown.objects.Rectangle(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Rect));
        return new Rectangle2D.Double(box.getX(), this.getPageHeight() - box.getY(), box.getWidth(), box.getHeight());
    }

    public EnumSet<FlagsEnum> getFlags() {
        PdfInteger flagsObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.F);
        if (flagsObject == null) {
            return EnumSet.noneOf(FlagsEnum.class);
        }
        return FlagsEnum.toEnumSet((Integer)flagsObject.getRawValue());
    }

    public Date getModificationDate() {
        PdfDirectObject modificationDateObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.M);
        if (modificationDateObject == null || !(modificationDateObject instanceof PdfDate)) {
            return null;
        }
        return (Date)((PdfDate)modificationDateObject).getValue();
    }

    public String getName() {
        PdfTextString nameObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.NM);
        if (nameObject == null) {
            return null;
        }
        return (String)nameObject.getValue();
    }

    public Page getPage() {
        PdfDirectObject pageObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.P);
        if (pageObject == null) {
            return null;
        }
        return new Page(pageObject);
    }

    public String getText() {
        PdfTextString textObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Contents);
        if (textObject == null) {
            return null;
        }
        return (String)textObject.getValue();
    }

    public boolean isPrintable() {
        return this.getFlags().contains((Object)FlagsEnum.Print);
    }

    public boolean isVisible() {
        return !this.getFlags().contains((Object)FlagsEnum.Hidden);
    }

    public void setAction(Action value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.A);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, value.getBaseObject());
        }
    }

    public void setActions(AnnotationActions value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.AA);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AA, value.getBaseObject());
        }
    }

    public void setAppearance(Appearance value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.AP);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AP, value.getBaseObject());
        }
    }

    public void setBorder(Border value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.BS);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BS, value.getBaseObject());
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Border);
        }
    }

    public void setBox(Rectangle2D value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Rect, (PdfDirectObject)new it.stefanochizzolini.clown.objects.Rectangle(value.getX(), this.getPageHeight() - value.getY(), value.getWidth(), value.getHeight()).getBaseDataObject());
    }

    public void setFlags(EnumSet<FlagsEnum> value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, new PdfInteger(FlagsEnum.toInt(value)));
    }

    public void setModificationDate(Date value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.M, new PdfDate(value));
    }

    public void setName(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.NM, new PdfTextString(value));
    }

    public void setPage(Page value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.P, value.getBaseObject());
    }

    public void setPrintable(boolean value) {
        EnumSet<FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.add(FlagsEnum.Print);
        } else {
            flags.remove((Object)FlagsEnum.Print);
        }
        this.setFlags(flags);
    }

    public void setText(String value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Contents);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Contents, new PdfTextString(value));
        }
    }

    public void setVisible(boolean value) {
        EnumSet<FlagsEnum> flags = this.getFlags();
        if (value) {
            flags.remove((Object)FlagsEnum.Hidden);
        } else {
            flags.add(FlagsEnum.Hidden);
        }
        this.setFlags(flags);
    }

    private double getPageHeight() {
        Page page = this.getPage();
        return page != null ? page.getBox().getHeight() : this.getDocument().getSize().getHeight();
    }

    public static enum FlagsEnum {
        Invisible(1),
        Hidden(2),
        Print(4),
        NoZoom(8),
        NoRotate(16),
        NoView(32),
        ReadOnly(64),
        Locked(128),
        ToggleNoView(256);

        private final int code;

        public static int toInt(EnumSet<FlagsEnum> flags) {
            int flagsMask = 0;
            for (FlagsEnum flag : flags) {
                flagsMask |= flag.getCode();
            }
            return flagsMask;
        }

        public static EnumSet<FlagsEnum> toEnumSet(int flagsMask) {
            EnumSet<FlagsEnum> flags = EnumSet.noneOf(FlagsEnum.class);
            FlagsEnum[] flagsEnumArray = FlagsEnum.values();
            int n = flagsEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagsEnum flag = flagsEnumArray[n2];
                if ((flagsMask & flag.getCode()) > 0) {
                    flags.add(flag);
                }
                ++n2;
            }
            return flags;
        }

        private FlagsEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

