/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.actions;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.documents.interaction.annotations.Annotation;
import it.stefanochizzolini.clown.documents.interaction.forms.Field;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfBoolean;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.ArrayList;
import java.util.Collection;

public class ToggleVisibility
extends Action {
    public ToggleVisibility(Document context, Collection<PdfObjectWrapper<?>> objects, boolean visible) {
        super(context, PdfName.Hide);
        this.setObjects(objects);
        this.setVisible(visible);
    }

    ToggleVisibility(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public ToggleVisibility clone(Document context) {
        throw new NotImplementedException();
    }

    public Collection<PdfObjectWrapper<?>> getObjects() {
        ArrayList objects = new ArrayList();
        PdfDirectObject objectsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.T);
        this.fillObjects(objectsObject, objects);
        return objects;
    }

    public boolean isVisible() {
        PdfBoolean hideObject = (PdfBoolean)((PdfDictionary)this.getBaseDataObject()).get(PdfName.H);
        if (hideObject == null) {
            return false;
        }
        return (Boolean)hideObject.getValue() == false;
    }

    public void setObjects(Collection<PdfObjectWrapper<?>> value) {
        PdfArray objectsDataObject = new PdfArray();
        for (PdfObjectWrapper<?> item : value) {
            if (item instanceof Annotation) {
                objectsDataObject.add(item.getBaseObject());
                continue;
            }
            if (item instanceof Field) {
                objectsDataObject.add(new PdfTextString(((Field)item).getFullName()));
                continue;
            }
            throw new IllegalArgumentException("Invalid 'Hide' action target type (" + item.getClass().getName() + ").\n" + "It MUST be either an annotation or a form field.");
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, objectsDataObject);
    }

    public void setVisible(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.H, new PdfBoolean(!value));
    }

    private void fillObjects(PdfDataObject objectObject, Collection<PdfObjectWrapper<?>> objects) {
        PdfDataObject objectDataObject = File.resolve(objectObject);
        if (objectDataObject instanceof PdfArray) {
            for (PdfDirectObject itemObject : (PdfArray)objectDataObject) {
                this.fillObjects(itemObject, objects);
            }
        } else if (objectDataObject instanceof PdfDictionary) {
            objects.add(Annotation.wrap((PdfReference)objectObject));
        } else if (objectDataObject instanceof PdfTextString) {
            objects.add(this.getDocument().getForm().getFields().get((String)((PdfTextString)objectDataObject).getValue()));
        } else {
            throw new RuntimeException("Invalid 'Hide' action target type (" + objectDataObject.getClass().getName() + ").\n" + "It should be either an annotation or a form field.");
        }
    }
}

