/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.actions;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ChainedActions
extends PdfObjectWrapper<PdfDataObject>
implements List<Action> {
    private Action parent;

    ChainedActions(PdfDirectObject baseObject, PdfIndirectObject container, Action parent) {
        super(baseObject, container);
        this.parent = parent;
    }

    @Override
    public ChainedActions clone(Document context) {
        throw new NotImplementedException();
    }

    public Action getParent() {
        return this.parent;
    }

    @Override
    public void add(int index, Action value) {
        this.ensureArray().add(index, value.getBaseObject());
    }

    @Override
    public boolean addAll(int index, Collection<? extends Action> values) {
        PdfArray items = this.ensureArray();
        for (Action action : values) {
            items.add(index++, action.getBaseObject());
        }
        return true;
    }

    @Override
    public Action get(int index) {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
            }
            return Action.wrap(this.getBaseObject(), this.getContainer());
        }
        return Action.wrap(((PdfArray)baseDataObject).get(index), this.getContainer());
    }

    @Override
    public int indexOf(Object value) {
        if (!(value instanceof Action)) {
            return -1;
        }
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            if (!((Action)value).getBaseObject().equals(this.getBaseObject())) {
                return -1;
            }
            return 0;
        }
        return ((PdfArray)baseDataObject).indexOf(((Action)value).getBaseObject());
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.indexOf(value);
    }

    @Override
    public ListIterator<Action> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<Action> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public Action remove(int index) {
        PdfDirectObject actionObject = this.ensureArray().remove(index);
        return Action.wrap(actionObject, this.getContainer());
    }

    @Override
    public Action set(int index, Action value) {
        return Action.wrap(this.ensureArray().set(index, value.getBaseObject()), this.getContainer());
    }

    @Override
    public List<Action> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    @Override
    public boolean add(Action value) {
        return this.ensureArray().add(value.getBaseObject());
    }

    @Override
    public boolean addAll(Collection<? extends Action> values) {
        for (Action action : values) {
            this.add(action);
        }
        return true;
    }

    @Override
    public void clear() {
        this.ensureArray().clear();
    }

    @Override
    public boolean contains(Object value) {
        if (!(value instanceof Action)) {
            return false;
        }
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return ((Action)value).getBaseObject().equals(this.getBaseObject());
        }
        return ((PdfArray)baseDataObject).contains(((Action)value).getBaseObject());
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return false;
        }
        return ((PdfArray)baseDataObject).isEmpty();
    }

    @Override
    public boolean remove(Object value) {
        if (!(value instanceof Action)) {
            return false;
        }
        return this.ensureArray().remove(((Action)value).getBaseObject());
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return 1;
        }
        return ((PdfArray)baseDataObject).size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Action[0]);
    }

    @Override
    public <T> T[] toArray(T[] values) {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            if (values.length == 0) {
                values = new Object[]{Action.wrap(this.getBaseObject(), this.getContainer())};
            }
        } else {
            PdfArray actionObjects = (PdfArray)baseDataObject;
            if (values.length < actionObjects.size()) {
                values = new Object[actionObjects.size()];
            }
            PdfIndirectObject container = this.getContainer();
            int index = 0;
            int length = actionObjects.size();
            while (index < length) {
                values[index] = Action.wrap(actionObjects.get(index), container);
                ++index;
            }
        }
        return values;
    }

    @Override
    public Iterator<Action> iterator() {
        return new Iterator<Action>(){
            private int index = 0;
            private int size;
            {
                this.size = ChainedActions.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Action next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ChainedActions.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private PdfArray ensureArray() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            PdfArray actionsArray = new PdfArray();
            actionsArray.add(this.getBaseObject());
            this.setBaseObject(actionsArray);
            ((PdfDictionary)this.parent.getBaseDataObject()).put(PdfName.Next, actionsArray);
            baseDataObject = actionsArray;
        }
        return (PdfArray)baseDataObject;
    }
}

