/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.actions;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.actions.ChainedActions;
import it.stefanochizzolini.clown.documents.interaction.actions.DoTransition;
import it.stefanochizzolini.clown.documents.interaction.actions.GoTo3dView;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToEmbedded;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToFirstPage;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToLastPage;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToLocal;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToNextPage;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToPreviousPage;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToRemote;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToThread;
import it.stefanochizzolini.clown.documents.interaction.actions.GoToURI;
import it.stefanochizzolini.clown.documents.interaction.actions.ImportData;
import it.stefanochizzolini.clown.documents.interaction.actions.JavaScript;
import it.stefanochizzolini.clown.documents.interaction.actions.Launch;
import it.stefanochizzolini.clown.documents.interaction.actions.NamedAction;
import it.stefanochizzolini.clown.documents.interaction.actions.PlayMovie;
import it.stefanochizzolini.clown.documents.interaction.actions.PlaySound;
import it.stefanochizzolini.clown.documents.interaction.actions.Rendition;
import it.stefanochizzolini.clown.documents.interaction.actions.ResetForm;
import it.stefanochizzolini.clown.documents.interaction.actions.SetOcgState;
import it.stefanochizzolini.clown.documents.interaction.actions.SubmitForm;
import it.stefanochizzolini.clown.documents.interaction.actions.ToggleVisibility;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.util.NotImplementedException;

public class Action
extends PdfObjectWrapper<PdfDictionary> {
    public static final Action wrap(PdfReference reference) {
        return Action.wrap(reference, null);
    }

    public static final Action wrap(PdfDirectObject baseObject, PdfIndirectObject container) {
        if (baseObject == null) {
            return null;
        }
        PdfDictionary dataObject = (PdfDictionary)File.resolve(baseObject);
        PdfName actionType = (PdfName)dataObject.get(PdfName.S);
        if (actionType == null || dataObject.containsKey(PdfName.Type) && !dataObject.get(PdfName.Type).equals(PdfName.Action)) {
            return null;
        }
        if (actionType.equals(PdfName.GoTo)) {
            return new GoToLocal(baseObject, container);
        }
        if (actionType.equals(PdfName.GoToR)) {
            return new GoToRemote(baseObject, container);
        }
        if (actionType.equals(PdfName.GoToE)) {
            return new GoToEmbedded(baseObject, container);
        }
        if (actionType.equals(PdfName.Launch)) {
            return new Launch(baseObject, container);
        }
        if (actionType.equals(PdfName.Thread)) {
            return new GoToThread(baseObject, container);
        }
        if (actionType.equals(PdfName.URI)) {
            return new GoToURI(baseObject, container);
        }
        if (actionType.equals(PdfName.Sound)) {
            return new PlaySound(baseObject, container);
        }
        if (actionType.equals(PdfName.Movie)) {
            return new PlayMovie(baseObject, container);
        }
        if (actionType.equals(PdfName.Hide)) {
            return new ToggleVisibility(baseObject, container);
        }
        if (actionType.equals(PdfName.Named)) {
            PdfName actionName = (PdfName)dataObject.get(PdfName.N);
            if (actionName.equals(PdfName.NextPage)) {
                return new GoToNextPage(baseObject, container);
            }
            if (actionName.equals(PdfName.PrevPage)) {
                return new GoToPreviousPage(baseObject, container);
            }
            if (actionName.equals(PdfName.FirstPage)) {
                return new GoToFirstPage(baseObject, container);
            }
            if (actionName.equals(PdfName.LastPage)) {
                return new GoToLastPage(baseObject, container);
            }
            return new NamedAction(baseObject, container);
        }
        if (actionType.equals(PdfName.SubmitForm)) {
            return new SubmitForm(baseObject, container);
        }
        if (actionType.equals(PdfName.ResetForm)) {
            return new ResetForm(baseObject, container);
        }
        if (actionType.equals(PdfName.ImportData)) {
            return new ImportData(baseObject, container);
        }
        if (actionType.equals(PdfName.JavaScript)) {
            return new JavaScript(baseObject, container);
        }
        if (actionType.equals(PdfName.SetOCGState)) {
            return new SetOcgState(baseObject, container);
        }
        if (actionType.equals(PdfName.Rendition)) {
            return new Rendition(baseObject, container);
        }
        if (actionType.equals(PdfName.Trans)) {
            return new DoTransition(baseObject, container);
        }
        if (actionType.equals(PdfName.GoTo3DView)) {
            return new GoTo3dView(baseObject, container);
        }
        return new Action(baseObject, container);
    }

    protected Action(Document context, PdfName actionType) {
        super(context.getFile(), new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.S}, new PdfDirectObject[]{PdfName.Action, actionType}));
    }

    protected Action(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Action clone(Document context) {
        throw new NotImplementedException();
    }

    public ChainedActions getActions() {
        PdfDirectObject nextObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Next);
        if (nextObject == null) {
            return null;
        }
        return new ChainedActions(nextObject, this.getContainer(), this);
    }

    public void setActions(ChainedActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Next, value.getBaseObject());
    }
}

