/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.fileSpecs;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.fileSpecs.EmbeddedFile;
import it.stefanochizzolini.clown.documents.fileSpecs.RelatedFiles;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfNamedObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.util.NotImplementedException;

public class FileSpec
extends PdfNamedObjectWrapper<PdfDictionary> {
    public FileSpec(Document context) {
        super(context.getFile(), new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Filespec}));
    }

    public FileSpec(EmbeddedFile embeddedFile, String filename) {
        this(embeddedFile.getDocument());
        this.setFilename(filename);
        this.setEmbeddedFile(embeddedFile);
    }

    public FileSpec(PdfDirectObject baseObject, PdfIndirectObject container, PdfString name) {
        super(baseObject, container, name);
    }

    @Override
    public FileSpec clone(Document context) {
        throw new NotImplementedException();
    }

    public RelatedFiles getDependencies() {
        return this.getDependencies(PdfName.F);
    }

    public String getDescription() {
        PdfTextString descriptionObject = (PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Desc);
        if (descriptionObject == null) {
            return null;
        }
        return (String)descriptionObject.getValue();
    }

    public EmbeddedFile getEmbeddedFile() {
        return this.getEmbeddedFile(PdfName.F);
    }

    public RelatedFiles getMacDependencies() {
        return this.getDependencies(PdfName.Mac);
    }

    public EmbeddedFile getMacEmbeddedFile() {
        return this.getEmbeddedFile(PdfName.Mac);
    }

    public String getMacFilename() {
        return this.getFilename(PdfName.Mac);
    }

    public String getFilename() {
        return this.getFilename(PdfName.F);
    }

    public RelatedFiles getUnixDependencies() {
        return this.getDependencies(PdfName.Unix);
    }

    public EmbeddedFile getUnixEmbeddedFile() {
        return this.getEmbeddedFile(PdfName.Unix);
    }

    public String getUnixFilename() {
        return this.getFilename(PdfName.Unix);
    }

    public RelatedFiles getWinDependencies() {
        return this.getDependencies(PdfName.DOS);
    }

    public EmbeddedFile getWinEmbeddedFile() {
        return this.getEmbeddedFile(PdfName.DOS);
    }

    public String getWinFilename() {
        return this.getFilename(PdfName.DOS);
    }

    public void setDescription(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Desc, new PdfTextString(value));
    }

    public void setDependencies(RelatedFiles value) {
        this.setDependencies(PdfName.F, value);
    }

    public void setEmbeddedFile(EmbeddedFile value) {
        this.setEmbeddedFile(PdfName.F, value);
    }

    public void setMacDependencies(RelatedFiles value) {
        this.setDependencies(PdfName.Mac, value);
    }

    public void setMacEmbeddedFile(EmbeddedFile value) {
        this.setEmbeddedFile(PdfName.Mac, value);
    }

    public void setMacFilename(String value) {
        this.setFilename(PdfName.Mac, value);
    }

    public void setFilename(String value) {
        this.setFilename(PdfName.F, value);
    }

    public void setUnixDependencies(RelatedFiles value) {
        this.setDependencies(PdfName.Unix, value);
    }

    public void setUnixEmbeddedFile(EmbeddedFile value) {
        this.setEmbeddedFile(PdfName.Unix, value);
    }

    public void setUnixFilename(String value) {
        this.setFilename(PdfName.Unix, value);
    }

    public void setWinDependencies(RelatedFiles value) {
        this.setDependencies(PdfName.DOS, value);
    }

    public void setWinEmbeddedFile(EmbeddedFile value) {
        this.setEmbeddedFile(PdfName.DOS, value);
    }

    public void setWinFilename(String value) {
        this.setFilename(PdfName.DOS, value);
    }

    private RelatedFiles getDependencies(PdfName key) {
        PdfDictionary dependenciesObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.RF);
        if (dependenciesObject == null) {
            return null;
        }
        PdfReference dependencyFilesObject = (PdfReference)dependenciesObject.get(key);
        if (dependencyFilesObject == null) {
            return null;
        }
        return new RelatedFiles(dependencyFilesObject, this.getContainer());
    }

    private EmbeddedFile getEmbeddedFile(PdfName key) {
        PdfDictionary embeddedFilesObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.EF);
        if (embeddedFilesObject == null) {
            return null;
        }
        PdfReference embeddedFileObject = (PdfReference)embeddedFilesObject.get(key);
        if (embeddedFileObject == null) {
            return null;
        }
        return new EmbeddedFile(embeddedFileObject);
    }

    private String getFilename(PdfName key) {
        PdfString nameObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(key);
        if (nameObject == null) {
            return null;
        }
        return (String)nameObject.getValue();
    }

    private void setDependencies(PdfName key, RelatedFiles value) {
        PdfDictionary dependenciesObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.RF);
        if (dependenciesObject == null) {
            dependenciesObject = new PdfDictionary();
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.RF, dependenciesObject);
        }
        dependenciesObject.put(key, value.getBaseObject());
    }

    private void setEmbeddedFile(PdfName key, EmbeddedFile value) {
        PdfDictionary embeddedFilesObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.EF);
        if (embeddedFilesObject == null) {
            embeddedFilesObject = new PdfDictionary();
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.EF, embeddedFilesObject);
        }
        embeddedFilesObject.put(key, value.getBaseObject());
    }

    private void setFilename(PdfName key, String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(key, new PdfString(value));
    }
}

