/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.tokens;

import it.stefanochizzolini.clown.bytes.Buffer;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.documents.contents.objects.BeginInlineImage;
import it.stefanochizzolini.clown.documents.contents.objects.BeginMarkedContent;
import it.stefanochizzolini.clown.documents.contents.objects.BeginSubpath;
import it.stefanochizzolini.clown.documents.contents.objects.BeginText;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.objects.DrawRectangle;
import it.stefanochizzolini.clown.documents.contents.objects.EndInlineImage;
import it.stefanochizzolini.clown.documents.contents.objects.EndMarkedContent;
import it.stefanochizzolini.clown.documents.contents.objects.EndText;
import it.stefanochizzolini.clown.documents.contents.objects.InlineImage;
import it.stefanochizzolini.clown.documents.contents.objects.InlineImageBody;
import it.stefanochizzolini.clown.documents.contents.objects.InlineImageHeader;
import it.stefanochizzolini.clown.documents.contents.objects.LocalGraphicsState;
import it.stefanochizzolini.clown.documents.contents.objects.MarkedContent;
import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.documents.contents.objects.PaintPath;
import it.stefanochizzolini.clown.documents.contents.objects.PaintShading;
import it.stefanochizzolini.clown.documents.contents.objects.PaintXObject;
import it.stefanochizzolini.clown.documents.contents.objects.Path;
import it.stefanochizzolini.clown.documents.contents.objects.RestoreGraphicsState;
import it.stefanochizzolini.clown.documents.contents.objects.SaveGraphicsState;
import it.stefanochizzolini.clown.documents.contents.objects.Shading;
import it.stefanochizzolini.clown.documents.contents.objects.Text;
import it.stefanochizzolini.clown.documents.contents.objects.XObject;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfBoolean;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDate;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfStream;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.tokens.FileFormatException;
import it.stefanochizzolini.clown.tokens.TokenTypeEnum;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Parser {
    private final PdfDataObject contentStream;
    private long basePosition;
    private IInputStream stream;
    private int streamIndex = -1;
    private Object token;
    private TokenTypeEnum tokenType;

    protected static int getHex(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        return -1;
    }

    protected static boolean isDelimiter(int c) {
        return c == 40 || c == 41 || c == 60 || c == 62 || c == 91 || c == 93 || c == 47 || c == 37;
    }

    protected static boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    protected static boolean isWhitespace(int c) {
        return c == 32 || Parser.isEOL(c) || c == 0 || c == 9 || c == 12;
    }

    public Parser(PdfDataObject contentStream) {
        this.contentStream = contentStream;
        this.moveNextStream();
    }

    public PdfDataObject getContentStream() {
        return this.contentStream;
    }

    public long getLength() {
        if (this.contentStream instanceof PdfStream) {
            return ((PdfStream)this.contentStream).getBody().getLength();
        }
        int length = 0;
        for (PdfDirectObject stream : (PdfArray)this.contentStream) {
            length = (int)((long)length + ((PdfStream)((PdfReference)stream).getDataObject()).getBody().getLength());
        }
        return length;
    }

    public long getPosition() {
        return this.basePosition + this.stream.getPosition();
    }

    public IInputStream getStream() {
        return this.stream;
    }

    public int getStreamIndex() {
        return this.streamIndex;
    }

    public Object getToken() {
        return this.token;
    }

    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public boolean moveNext(int offset) throws FileFormatException {
        int index = 0;
        while (index < offset) {
            if (!this.moveNext()) {
                return false;
            }
            ++index;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean moveNext() throws FileFormatException {
        int c = 0;
        while (true) {
            try {
                while (Parser.isWhitespace(c = this.stream.readUnsignedByte())) {
                }
            }
            catch (EOFException e) {
                this.moveNextStream();
                continue;
            }
            catch (Exception e) {
                if (this.stream == null) return false;
                continue;
            }
            break;
        }
        StringBuilder buffer = null;
        this.token = null;
        block10 : switch (c) {
            case 47: {
                this.tokenType = TokenTypeEnum.Name;
                buffer = new StringBuilder();
                try {
                    while (!Parser.isDelimiter(c = this.stream.readUnsignedByte()) && !Parser.isWhitespace(c)) {
                        if (c == 35) {
                            try {
                                c = (Parser.getHex(this.stream.readUnsignedByte()) << 4) + Parser.getHex(this.stream.readUnsignedByte());
                            }
                            catch (EOFException e) {
                                throw new FileFormatException("Unexpected EOF (malformed hexadecimal code in name object).", e, this.stream.getPosition());
                            }
                        }
                        buffer.append((char)c);
                    }
                }
                catch (EOFException e) {
                    // empty catch block
                }
                this.stream.skip(-1L);
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                switch (c) {
                    case 46: {
                        this.tokenType = TokenTypeEnum.Real;
                        break;
                    }
                    default: {
                        this.tokenType = TokenTypeEnum.Integer;
                    }
                }
                buffer = new StringBuilder();
                try {
                    while (true) {
                        buffer.append((char)c);
                        c = this.stream.readUnsignedByte();
                        if (c == 46) {
                            this.tokenType = TokenTypeEnum.Real;
                            continue;
                        }
                        if (c < 48 || c > 57) break;
                    }
                }
                catch (EOFException e) {
                    // empty catch block
                }
                this.stream.skip(-1L);
                break;
            }
            case 91: {
                this.tokenType = TokenTypeEnum.ArrayBegin;
                break;
            }
            case 93: {
                this.tokenType = TokenTypeEnum.ArrayEnd;
                break;
            }
            case 60: {
                try {
                    c = this.stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (isolated opening angle-bracket character).", e, this.stream.getPosition());
                }
                if (c == 60) {
                    this.tokenType = TokenTypeEnum.DictionaryBegin;
                    break;
                }
                this.tokenType = TokenTypeEnum.Hex;
                buffer = new StringBuilder();
                try {
                    while (c != 62) {
                        buffer.append((char)c);
                        c = this.stream.readUnsignedByte();
                    }
                    break;
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed hex string).", e, this.stream.getPosition());
                }
            }
            case 62: {
                try {
                    c = this.stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed dictionary).", e, this.stream.getPosition());
                }
                if (c != 62) {
                    throw new FileFormatException("Malformed dictionary.", this.stream.getPosition());
                }
                this.tokenType = TokenTypeEnum.DictionaryEnd;
                break;
            }
            case 37: {
                this.tokenType = TokenTypeEnum.Comment;
                try {
                    while (!Parser.isEOL(c = this.stream.readUnsignedByte())) {
                    }
                }
                catch (EOFException e) {}
                break;
            }
            case 40: {
                this.tokenType = TokenTypeEnum.Literal;
                buffer = new StringBuilder();
                int level = 0;
                try {
                    while (true) {
                        if ((c = this.stream.readUnsignedByte()) == 40) {
                            ++level;
                        } else if (c == 41) {
                            --level;
                        } else if (c == 92) {
                            boolean lineBreak = false;
                            c = this.stream.readUnsignedByte();
                            switch (c) {
                                case 110: {
                                    c = 10;
                                    break;
                                }
                                case 114: {
                                    c = 13;
                                    break;
                                }
                                case 116: {
                                    c = 9;
                                    break;
                                }
                                case 98: {
                                    c = 8;
                                    break;
                                }
                                case 102: {
                                    c = 12;
                                    break;
                                }
                                case 40: 
                                case 41: 
                                case 92: {
                                    break;
                                }
                                case 13: {
                                    lineBreak = true;
                                    c = this.stream.readUnsignedByte();
                                    if (c == 10) break;
                                    this.stream.skip(-1L);
                                    break;
                                }
                                case 10: {
                                    lineBreak = true;
                                    break;
                                }
                                default: {
                                    if (c < 48 || c > 55) break;
                                    int octal = c - 48;
                                    c = this.stream.readUnsignedByte();
                                    if (c < 48 || c > 55) {
                                        c = octal;
                                        this.stream.skip(-1L);
                                        break;
                                    }
                                    octal = (octal << 3) + c - 48;
                                    c = this.stream.readUnsignedByte();
                                    if (c < 48 || c > 55) {
                                        c = octal;
                                        this.stream.skip(-1L);
                                        break;
                                    }
                                    octal = (octal << 3) + c - 48;
                                    c = octal & 0xFF;
                                }
                            }
                            if (lineBreak) {
                                continue;
                            }
                        } else if (c == 13 && (c = this.stream.readUnsignedByte()) != 10) {
                            c = 10;
                            this.stream.skip(-1L);
                        }
                        if (level == -1) break block10;
                        buffer.append((char)c);
                    }
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed literal string).", e, this.stream.getPosition());
                }
            }
            default: {
                this.tokenType = TokenTypeEnum.Keyword;
                buffer = new StringBuilder();
                try {
                    do {
                        buffer.append((char)c);
                    } while (!Parser.isDelimiter(c = this.stream.readUnsignedByte()) && !Parser.isWhitespace(c));
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                this.stream.skip(-1L);
            }
        }
        if (buffer == null) return true;
        switch (this.tokenType) {
            case Keyword: {
                this.token = buffer.toString();
                if (((String)this.token).equals("false") || ((String)this.token).equals("true")) {
                    this.tokenType = TokenTypeEnum.Boolean;
                    this.token = Boolean.parseBoolean((String)this.token);
                    return true;
                }
                if (!((String)this.token).equals("null")) return true;
                this.tokenType = TokenTypeEnum.Null;
                this.token = null;
                return true;
            }
            case Hex: 
            case Name: 
            case Comment: {
                this.token = buffer.toString();
                return true;
            }
            case Literal: {
                this.token = buffer.toString();
                if (!((String)this.token).startsWith("D:")) return true;
                this.tokenType = TokenTypeEnum.Date;
                this.token = PdfDate.toDate((String)this.token);
                return true;
            }
            case Integer: {
                this.token = Integer.parseInt(buffer.toString());
                return true;
            }
            case Real: {
                this.token = Float.valueOf(Float.parseFloat(buffer.toString()));
            }
        }
        return true;
    }

    public ContentObject parseContentObject() throws FileFormatException {
        Operation operation = this.parseOperation();
        if (operation instanceof PaintXObject) {
            return new XObject((PaintXObject)operation);
        }
        if (operation instanceof PaintShading) {
            return new Shading((PaintShading)operation);
        }
        if (operation instanceof BeginSubpath || operation instanceof DrawRectangle) {
            return this.parsePath(operation);
        }
        if (operation instanceof BeginText) {
            return new Text(this.parseContentObjects());
        }
        if (operation instanceof SaveGraphicsState) {
            return new LocalGraphicsState(this.parseContentObjects());
        }
        if (operation instanceof BeginMarkedContent) {
            return new MarkedContent((BeginMarkedContent)operation, this.parseContentObjects());
        }
        if (operation instanceof BeginInlineImage) {
            return this.parseInlineImage();
        }
        return operation;
    }

    public List<ContentObject> parseContentObjects() throws FileFormatException {
        ArrayList<ContentObject> contentObjects = new ArrayList<ContentObject>();
        while (this.moveNext()) {
            ContentObject contentObject = this.parseContentObject();
            if (contentObject instanceof EndText || contentObject instanceof RestoreGraphicsState || contentObject instanceof EndMarkedContent || contentObject instanceof EndInlineImage) {
                return contentObjects;
            }
            contentObjects.add(contentObject);
        }
        return contentObjects;
    }

    public Operation parseOperation() throws FileFormatException {
        String operator = null;
        ArrayList<PdfDirectObject> operands = new ArrayList<PdfDirectObject>();
        while (true) {
            if (this.tokenType == TokenTypeEnum.Keyword) break;
            operands.add(this.parsePdfObject());
            this.moveNext();
        }
        operator = (String)this.token;
        return Operation.get(operator, operands);
    }

    protected PdfDirectObject parsePdfObject() throws FileFormatException {
        switch (this.tokenType) {
            case Integer: {
                return new PdfInteger((Integer)this.token);
            }
            case Name: {
                return new PdfName((String)this.token, true);
            }
            case Literal: {
                try {
                    return new PdfString(((String)this.token).getBytes("ISO-8859-1"), PdfString.SerializationModeEnum.Literal);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DictionaryBegin: {
                PdfDictionary dictionary = new PdfDictionary();
                while (true) {
                    this.moveNext();
                    if (this.tokenType == TokenTypeEnum.DictionaryEnd) break;
                    PdfName key = (PdfName)this.parsePdfObject();
                    this.moveNext();
                    PdfDirectObject value = this.parsePdfObject();
                    dictionary.put(key, value);
                }
                return dictionary;
            }
            case ArrayBegin: {
                PdfArray array = new PdfArray();
                while (true) {
                    this.moveNext();
                    if (this.tokenType == TokenTypeEnum.ArrayEnd) break;
                    array.add(this.parsePdfObject());
                }
                return array;
            }
            case Real: {
                return new PdfReal(((Float)this.token).floatValue());
            }
            case Boolean: {
                return new PdfBoolean((Boolean)this.token);
            }
            case Date: {
                return new PdfDate((Date)this.token);
            }
            case Hex: {
                try {
                    return new PdfString((String)this.token, PdfString.SerializationModeEnum.Hex);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case Null: {
                return null;
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)this.tokenType));
    }

    public void seek(long position) {
        block2: {
            while (true) {
                if (position < this.basePosition) {
                    if (this.movePreviousStream()) continue;
                    throw new IllegalArgumentException("The 'position' argument is lower than acceptable.");
                }
                if (position <= this.basePosition + this.stream.getLength()) break block2;
                if (!this.moveNextStream()) break;
            }
            throw new IllegalArgumentException("The 'position' argument is higher than acceptable.");
        }
        this.stream.seek(position - this.basePosition);
    }

    public void skip(long offset) {
        long position;
        block3: {
            while (true) {
                if ((position = this.stream.getPosition() + offset) < 0L) {
                    offset += this.stream.getPosition();
                    if (!this.movePreviousStream()) {
                        throw new IllegalArgumentException("The 'offset' argument is lower than acceptable.");
                    }
                    this.stream.setPosition(this.stream.getLength());
                    continue;
                }
                if (position <= this.stream.getLength()) break block3;
                offset -= this.stream.getLength() - this.stream.getPosition();
                if (!this.moveNextStream()) break;
            }
            throw new IllegalArgumentException("The 'offset' argument is higher than acceptable.");
        }
        this.stream.skip(position);
    }

    public boolean skipWhitespace() {
        try {
            int b;
            while (Parser.isWhitespace(b = this.stream.readUnsignedByte())) {
            }
        }
        catch (EOFException e) {
            return false;
        }
        this.stream.skip(-1L);
        return true;
    }

    private boolean moveNextStream() {
        if (this.contentStream instanceof PdfStream) {
            if (this.streamIndex == 0) {
                ++this.streamIndex;
                this.basePosition += this.stream.getLength();
                this.stream = null;
            }
            if (this.streamIndex == 1) {
                return false;
            }
            ++this.streamIndex;
            this.basePosition = 0L;
            this.stream = ((PdfStream)this.contentStream).getBody();
        } else {
            PdfArray streams = (PdfArray)this.contentStream;
            if (this.streamIndex == streams.size() - 1) {
                ++this.streamIndex;
                this.basePosition += this.stream.getLength();
                this.stream = null;
            }
            if (this.streamIndex == streams.size()) {
                return false;
            }
            ++this.streamIndex;
            this.basePosition = this.streamIndex == 0 ? 0L : (this.basePosition += this.stream.getLength());
            this.stream = ((PdfStream)((PdfReference)streams.get(this.streamIndex)).getDataObject()).getBody();
        }
        return true;
    }

    private boolean movePreviousStream() {
        if (this.streamIndex == 0) {
            --this.streamIndex;
            this.stream = null;
        }
        if (this.streamIndex == -1) {
            return false;
        }
        --this.streamIndex;
        if (this.contentStream instanceof PdfStream) {
            this.stream = ((PdfStream)this.contentStream).getBody();
            this.basePosition = 0L;
        } else {
            PdfArray streams = (PdfArray)this.contentStream;
            this.stream = ((PdfStream)((PdfReference)streams.get(this.streamIndex)).getDataObject()).getBody();
            this.basePosition -= this.stream.getLength();
        }
        return true;
    }

    private InlineImage parseInlineImage() throws FileFormatException {
        ArrayList<PdfDirectObject> operands = new ArrayList<PdfDirectObject>();
        while (this.moveNext() && this.tokenType != TokenTypeEnum.Keyword) {
            operands.add(this.parsePdfObject());
        }
        InlineImageHeader header = new InlineImageHeader(operands);
        this.moveNext();
        Buffer data = new Buffer();
        byte c1 = 0;
        byte c2 = 0;
        block3: while (true) {
            try {
                while (true) {
                    c1 = this.stream.readByte();
                    c2 = this.stream.readByte();
                    if (c1 == 69 && c2 == 73) break block3;
                    data.append(c1);
                    data.append(c2);
                }
            }
            catch (EOFException e) {
                this.moveNextStream();
                if (this.stream != null) continue;
            }
            break;
        }
        InlineImageBody body = new InlineImageBody(data);
        return new InlineImage(header, body);
    }

    private Path parsePath(Operation beginOperation) throws FileFormatException {
        ArrayList<ContentObject> operations = new ArrayList<ContentObject>();
        operations.add(beginOperation);
        long position = this.getPosition();
        boolean closeable = false;
        while (this.moveNext()) {
            Operation operation = this.parseOperation();
            if (operation instanceof PaintPath) {
                closeable = true;
            } else if (closeable) {
                this.seek(position);
                break;
            }
            operations.add(operation);
            position = this.getPosition();
        }
        return new Path(operations);
    }
}

