/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfReal;
import java.util.Arrays;
import java.util.List;

public final class TranslateTextRelative
extends Operation {
    public static final String SimpleOperator = "Td";
    public static final String LeadOperator = "TD";

    public TranslateTextRelative(double offsetX, double offsetY) {
        this(offsetX, offsetY, false);
    }

    public TranslateTextRelative(double offsetX, double offsetY, boolean leadSet) {
        super(leadSet ? LeadOperator : SimpleOperator, new PdfReal(offsetX), new PdfReal(offsetY));
    }

    public TranslateTextRelative(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    @Override
    public void applyTo(ContentScanner.GraphicsState state) {
        state.tm = ContentScanner.GraphicsState.concat(new double[]{1.0, 0.0, 0.0, 1.0, this.getOffsetX(), this.getOffsetY()}, state.tlm);
        state.tlm = Arrays.copyOf(state.tm, state.tm.length);
        if (this.isLeadSet()) {
            state.lead = this.getOffsetY();
        }
    }

    public double getOffsetX() {
        return ((IPdfNumber)this.operands.get(0)).getNumberValue();
    }

    public double getOffsetY() {
        return ((IPdfNumber)this.operands.get(1)).getNumberValue();
    }

    public boolean isLeadSet() {
        return this.operator.equals(LeadOperator);
    }

    public void setLeadSet(boolean value) {
        this.operator = value ? LeadOperator : SimpleOperator;
    }

    public void setOffsetX(double value) {
        ((IPdfNumber)this.operands.get(0)).setNumberValue(value);
    }

    public void setOffsetY(double value) {
        ((IPdfNumber)this.operands.get(1)).setNumberValue(value);
    }
}

