/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.objects.ShowText;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfString;
import java.util.List;

public final class ShowTextToNextLine
extends ShowText {
    public static final String SimpleOperator = "'";
    public static final String SpaceOperator = "''";

    public ShowTextToNextLine(byte[] text) {
        super(SimpleOperator, new PdfDirectObject[]{new PdfString(text)});
    }

    public ShowTextToNextLine(byte[] text, double wordSpace, double charSpace) {
        super(SpaceOperator, new PdfReal(wordSpace), new PdfReal(charSpace), new PdfString(text));
    }

    public ShowTextToNextLine(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    public Double getCharSpace() {
        if (this.operator.equals(SimpleOperator)) {
            return null;
        }
        return ((IPdfNumber)this.operands.get(1)).getNumberValue();
    }

    @Override
    public byte[] getText() {
        return (byte[])((PdfString)this.operands.get(this.operator.equals(SimpleOperator) ? 0 : 2)).getRawValue();
    }

    public Double getWordSpace() {
        if (this.operator.equals(SimpleOperator)) {
            return null;
        }
        return ((IPdfNumber)this.operands.get(0)).getNumberValue();
    }

    public void setCharSpace(Double value) {
        this.ensureSpaceOperation();
        ((IPdfNumber)this.operands.get(1)).setNumberValue(value);
    }

    @Override
    public void setText(byte[] value) {
        ((PdfString)this.operands.get(this.operator.equals(SimpleOperator) ? 0 : 2)).setRawValue(value);
    }

    public void setWordSpace(Double value) {
        this.ensureSpaceOperation();
        ((IPdfNumber)this.operands.get(0)).setNumberValue(value);
    }

    private void ensureSpaceOperation() {
        if (this.operator.equals(SimpleOperator)) {
            this.operator = SpaceOperator;
            this.operands.add(0, new PdfReal(0.0));
            this.operands.add(1, new PdfReal(0.0));
        }
    }
}

