/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.objects.ShowText;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfAtomicObject;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ShowAdjustedText
extends ShowText {
    public static final String Operator = "TJ";

    public ShowAdjustedText(List<Object> value, int reserved) {
        super(Operator);
        this.setValue(value);
    }

    public ShowAdjustedText(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    @Override
    public byte[] getText() {
        ByteArrayOutputStream textStream = new ByteArrayOutputStream();
        for (PdfDirectObject element : (PdfArray)this.operands.get(0)) {
            if (!(element instanceof PdfString)) continue;
            try {
                textStream.write((byte[])((PdfString)element).getRawValue());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return textStream.toByteArray();
    }

    @Override
    public List<Object> getValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        for (PdfDirectObject element : (PdfArray)this.operands.get(0)) {
            value.add(((PdfAtomicObject)element).getRawValue());
        }
        return value;
    }

    @Override
    public void setText(byte[] value) {
        this.setValue(Arrays.asList(new Object[]{value}));
    }

    @Override
    public void setValue(List<Object> value) {
        PdfArray elements = new PdfArray();
        this.operands.set(0, elements);
        boolean textItemExpected = true;
        for (Object valueItem : value) {
            PdfAtomicObject element = textItemExpected ? new PdfString((byte[])valueItem) : new PdfReal((Double)valueItem);
            elements.add(element);
            boolean bl = textItemExpected = !textItemExpected;
        }
    }
}

