/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceCMYKColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceRGBColorSpace;
import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import java.util.List;

public final class SetStrokeColorSpace
extends Operation {
    public static final String Operator = "CS";

    public SetStrokeColorSpace(PdfName name) {
        super(Operator, (PdfDirectObject)name);
    }

    public SetStrokeColorSpace(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    @Override
    public void applyTo(ContentScanner.GraphicsState state) {
        PdfName name = this.getName();
        state.strokeColorSpace = name.equals(PdfName.DeviceGray) ? DeviceGrayColorSpace.Default : (name.equals(PdfName.DeviceRGB) ? DeviceRGBColorSpace.Default : (name.equals(PdfName.DeviceCMYK) ? DeviceCMYKColorSpace.Default : state.getScanner().getContentContext().getResources().getColorSpaces().get(name)));
        if (state.strokeColorSpace != null) {
            state.strokeColor = state.strokeColorSpace.getDefaultColor();
        }
    }

    public PdfName getName() {
        return (PdfName)this.operands.get(0);
    }

    public void setName(PdfName value) {
        this.operands.set(0, value);
    }
}

