/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.LineDash;
import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfReal;
import java.util.List;

public final class SetLineDash
extends Operation {
    public static final String Operator = "d";

    public SetLineDash(double phase, double unitsOn, double unitsOff) {
        super(Operator, new PdfArray(new PdfReal(unitsOn), new PdfReal(unitsOff)), new PdfReal(phase));
    }

    public SetLineDash(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    @Override
    public void applyTo(ContentScanner.GraphicsState state) {
        state.lineDash = this.getValue();
    }

    public LineDash getValue() {
        PdfArray baseDashArray = (PdfArray)this.operands.get(0);
        double[] dashArray = new double[baseDashArray.size()];
        int index = 0;
        int length = dashArray.length;
        while (index < length) {
            dashArray[index] = ((IPdfNumber)((Object)baseDashArray.get(index))).getNumberValue();
            ++index;
        }
        double dashPhase = ((IPdfNumber)this.operands.get(1)).getNumberValue();
        return new LineDash(dashArray, dashPhase);
    }

    public void setValue(LineDash value) {
        double[] dashArray = value.getDashArray();
        PdfArray baseDashArray = new PdfArray(dashArray.length);
        int index = 0;
        int length = dashArray.length;
        while (index < length) {
            baseDashArray.set(index, new PdfReal(dashArray[index]));
            ++index;
        }
        this.operands.set(0, baseDashArray);
        ((IPdfNumber)this.operands.get(1)).setNumberValue(value.getDashPhase());
    }
}

