/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceCMYKColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceRGBColorSpace;
import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import java.util.List;

public final class SetFillColorSpace
extends Operation {
    public static final String Operator = "cs";

    public SetFillColorSpace(PdfName name) {
        super(Operator, (PdfDirectObject)name);
    }

    public SetFillColorSpace(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    @Override
    public void applyTo(ContentScanner.GraphicsState state) {
        PdfName name = this.getName();
        state.fillColorSpace = name.equals(PdfName.DeviceGray) ? DeviceGrayColorSpace.Default : (name.equals(PdfName.DeviceRGB) ? DeviceRGBColorSpace.Default : (name.equals(PdfName.DeviceCMYK) ? DeviceCMYKColorSpace.Default : state.getScanner().getContentContext().getResources().getColorSpaces().get(name)));
        if (state.fillColorSpace != null) {
            state.fillColor = state.fillColorSpace.getDefaultColor();
        }
    }

    public PdfName getName() {
        return (PdfName)this.operands.get(0);
    }

    public void setName(PdfName value) {
        this.operands.set(0, value);
    }
}

