/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.ExtGState;
import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import java.util.List;

public final class SetExtGState
extends Operation {
    public static final String Operator = "gs";

    public SetExtGState(PdfName name) {
        super(Operator, (PdfDirectObject)name);
    }

    public SetExtGState(List<PdfDirectObject> operands) {
        super(Operator, operands);
    }

    @Override
    public void applyTo(ContentScanner.GraphicsState state) {
        ExtGState extGState = state.getScanner().getContentContext().getResources().getExtGStates().get(this.getName());
        for (PdfName parameterName : ((PdfDictionary)extGState.getBaseDataObject()).keySet()) {
            if (parameterName.equals(PdfName.Font)) {
                state.font = extGState.getFont();
                state.fontSize = extGState.getFontSize();
                continue;
            }
            if (parameterName.equals(PdfName.LC)) {
                state.lineCap = extGState.getLineCap();
                continue;
            }
            if (parameterName.equals(PdfName.D)) {
                state.lineDash = extGState.getLineDash();
                continue;
            }
            if (parameterName.equals(PdfName.LJ)) {
                state.lineJoin = extGState.getLineJoin();
                continue;
            }
            if (parameterName.equals(PdfName.LW)) {
                state.lineWidth = extGState.getLineWidth();
                continue;
            }
            if (!parameterName.equals(PdfName.ML)) continue;
            state.miterLimit = extGState.getMiterLimit();
        }
    }

    public PdfName getName() {
        return (PdfName)this.operands.get(0);
    }

    public void setName(PdfName value) {
        this.operands.set(0, value);
    }
}

