/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.documents.contents.objects.Operation;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfReal;
import java.awt.geom.Point2D;
import java.util.List;

public final class DrawCurve
extends Operation {
    public static final String FinalOperator = "v";
    public static final String FullOperator = "c";
    public static final String InitialOperator = "y";

    public DrawCurve(Point2D point, Point2D control1, Point2D control2) {
        this(point.getX(), point.getY(), control1.getX(), control1.getY(), control2.getX(), control2.getY());
    }

    public DrawCurve(double pointX, double pointY, double control1X, double control1Y, double control2X, double control2Y) {
        super(FullOperator, new PdfReal(control1X), new PdfReal(control1Y), new PdfReal(control2X), new PdfReal(control2Y), new PdfReal(pointX), new PdfReal(pointY));
    }

    public DrawCurve(Point2D point, Point2D control, String operator) {
        super(operator.equals(InitialOperator) ? InitialOperator : FinalOperator, new PdfReal(control.getX()), new PdfReal(control.getY()), new PdfReal(point.getX()), new PdfReal(point.getY()));
    }

    public DrawCurve(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    public Point2D getControl1() {
        if (this.operator.equals(FinalOperator)) {
            return null;
        }
        return new Point2D.Double(((IPdfNumber)this.operands.get(0)).getNumberValue(), ((IPdfNumber)this.operands.get(1)).getNumberValue());
    }

    public Point2D getControl2() {
        if (this.operator.equals(InitialOperator)) {
            return null;
        }
        if (this.operator.equals(FinalOperator)) {
            return new Point2D.Double(((IPdfNumber)this.operands.get(0)).getNumberValue(), ((IPdfNumber)this.operands.get(1)).getNumberValue());
        }
        return new Point2D.Double(((IPdfNumber)this.operands.get(2)).getNumberValue(), ((IPdfNumber)this.operands.get(3)).getNumberValue());
    }

    public Point2D getPoint() {
        return new Point2D.Double(((IPdfNumber)this.operands.get(0)).getNumberValue(), ((IPdfNumber)this.operands.get(1)).getNumberValue());
    }

    public void setControl1(Point2D value) {
        if (this.operator.equals(FinalOperator)) {
            this.operator = FullOperator;
        }
        ((IPdfNumber)this.operands.get(0)).setNumberValue(value.getX());
        ((IPdfNumber)this.operands.get(1)).setNumberValue(value.getY());
    }

    public void setControl2(Point2D value) {
        if (this.operator.equals(InitialOperator)) {
            this.operator = FullOperator;
        }
        if (this.operator.equals(FinalOperator)) {
            ((IPdfNumber)this.operands.get(0)).setNumberValue(value.getX());
            ((IPdfNumber)this.operands.get(1)).setNumberValue(value.getY());
        } else {
            ((IPdfNumber)this.operands.get(2)).setNumberValue(value.getX());
            ((IPdfNumber)this.operands.get(3)).setNumberValue(value.getY());
        }
    }

    public void setPoint(Point2D value) {
        ((IPdfNumber)this.operands.get(0)).setNumberValue(value.getX());
        ((IPdfNumber)this.operands.get(1)).setNumberValue(value.getY());
    }
}

