/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.objects;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import java.util.ArrayList;
import java.util.List;

public abstract class CompositeObject
extends ContentObject {
    protected List<ContentObject> objects;

    protected CompositeObject() {
        this.objects = new ArrayList<ContentObject>();
    }

    protected CompositeObject(ContentObject object) {
        this();
        this.objects.add(object);
    }

    protected CompositeObject(ContentObject ... objects) {
        this();
        ContentObject[] contentObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            ContentObject object = contentObjectArray[n2];
            this.objects.add(object);
            ++n2;
        }
    }

    protected CompositeObject(List<ContentObject> objects) {
        this.objects = objects;
    }

    @Override
    public void applyTo(ContentScanner.GraphicsState state) {
        ContentScanner childLevel = state.getScanner().getChildLevel();
        childLevel.moveEnd();
        childLevel.getState().copyTo(state);
    }

    public List<ContentObject> getObjects() {
        return this.objects;
    }

    public String toString() {
        return "{" + this.objects.toString() + "}";
    }

    @Override
    public void writeTo(IOutputStream stream) {
        for (ContentObject object : this.objects) {
            object.writeTo(stream);
        }
    }
}

