/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.fonts.AfmParser;
import it.stefanochizzolini.clown.documents.contents.fonts.Encoding;
import it.stefanochizzolini.clown.documents.contents.fonts.Font;
import it.stefanochizzolini.clown.documents.contents.fonts.Type1Font;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.ByteArray;
import it.stefanochizzolini.clown.util.ConvertUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Map;

public class StandardType1Font
extends Type1Font {
    public StandardType1Font(Document context, FamilyEnum family, boolean bold, boolean italic) {
        super(context);
        String fontName = family.name();
        switch (family) {
            case Symbol: 
            case ZapfDingbats: {
                break;
            }
            case Times: {
                if (bold) {
                    fontName = String.valueOf(fontName) + "-Bold";
                    if (!italic) break;
                    fontName = String.valueOf(fontName) + "Italic";
                    break;
                }
                if (italic) {
                    fontName = String.valueOf(fontName) + "-Italic";
                    break;
                }
                fontName = String.valueOf(fontName) + "-Roman";
                break;
            }
            default: {
                if (bold) {
                    fontName = String.valueOf(fontName) + "-Bold";
                    if (!italic) break;
                    fontName = String.valueOf(fontName) + "Oblique";
                    break;
                }
                if (!italic) break;
                fontName = String.valueOf(fontName) + "-Oblique";
            }
        }
        PdfName encodingName = family.isSymbolic() ? null : PdfName.WinAnsiEncoding;
        this.create(fontName, encodingName);
    }

    public StandardType1Font(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public double getAscent() {
        return this.metrics.ascender;
    }

    @Override
    public double getDescent() {
        return this.metrics.descender;
    }

    @Override
    public EnumSet<Font.FlagsEnum> getFlags() {
        return EnumSet.noneOf(Font.FlagsEnum.class);
    }

    @Override
    protected Map<ByteArray, Integer> getNativeEncoding() {
        if (this.symbolic) {
            Hashtable<ByteArray, Integer> codes = new Hashtable<ByteArray, Integer>();
            for (Map.Entry glyphIndexEntry : this.glyphIndexes.entrySet()) {
                codes.put(new ByteArray(new byte[]{ConvertUtils.intToByteArray((Integer)glyphIndexEntry.getValue())[3]}), (Integer)glyphIndexEntry.getKey());
            }
            return codes;
        }
        return Encoding.get(PdfName.StandardEncoding).getCodes();
    }

    @Override
    protected void onLoad() {
        this.load((String)((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.BaseFont)).getValue());
        super.onLoad();
    }

    private void create(String fontName, PdfName encodingName) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Subtype, PdfName.Type1);
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BaseFont, new PdfName(fontName));
        if (encodingName != null) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Encoding, encodingName);
        }
        this.load();
    }

    private void load(String fontName) {
        BufferedReader fontMetricsStream = null;
        try {
            try {
                fontMetricsStream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/fonts/afm/" + fontName + ".afm")));
                AfmParser parser = new AfmParser(fontMetricsStream);
                this.metrics = parser.metrics;
                this.symbolic = this.metrics.isCustomEncoding;
                this.glyphIndexes = parser.glyphIndexes;
                this.glyphKernings = parser.glyphKernings;
                this.glyphWidths = parser.glyphWidths;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load '" + fontName + "'.", e);
            }
        }
        finally {
            try {
                if (fontMetricsStream != null) {
                    fontMetricsStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static enum FamilyEnum {
        Courier(false),
        Helvetica(false),
        Times(false),
        Symbol(true),
        ZapfDingbats(true);

        private boolean symbolic;

        private FamilyEnum(boolean symbolic) {
            this.symbolic = symbolic;
        }

        public boolean isSymbolic() {
            return this.symbolic;
        }
    }
}

