/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.fonts.Font;
import it.stefanochizzolini.clown.documents.contents.fonts.GlyphMapping;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.ByteArray;
import java.util.Hashtable;
import java.util.Map;

public abstract class SimpleFont
extends Font {
    protected SimpleFont(Document context) {
        super(context);
    }

    protected SimpleFont(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    protected PdfDictionary getDescriptor() {
        return (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.FontDescriptor);
    }

    protected abstract void loadEncoding();

    protected void loadEncodingDifferences(PdfDictionary encodingDictionary, Map<ByteArray, Integer> codes) {
        PdfArray differenceObjects = (PdfArray)encodingDictionary.resolve(PdfName.Differences);
        if (differenceObjects == null) {
            return;
        }
        byte[] charCodeData = new byte[1];
        for (PdfDirectObject differenceObject : differenceObjects) {
            if (differenceObject instanceof PdfInteger) {
                charCodeData[0] = (byte)((Integer)((PdfInteger)differenceObject).getValue() & 0xFF);
                continue;
            }
            ByteArray charCode = new ByteArray(charCodeData);
            String charName = (String)((PdfName)differenceObject).getValue();
            if (charName.equals(".notdef")) {
                codes.remove(charCode);
            } else {
                try {
                    codes.put(charCode, GlyphMapping.nameToCode(charName));
                }
                catch (Exception e) {
                    codes.put(charCode, Integer.valueOf(charCodeData[0]));
                }
            }
            charCodeData[0] = (byte)(charCodeData[0] + 1);
        }
    }

    @Override
    protected void onLoad() {
        PdfDictionary descriptor;
        this.loadEncoding();
        if (this.glyphWidths == null) {
            this.glyphWidths = new Hashtable();
            PdfArray glyphWidthObjects = (PdfArray)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Widths);
            if (glyphWidthObjects != null) {
                ByteArray charCode = new ByteArray(new byte[]{(byte)((Integer)((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.FirstChar)).getRawValue()).intValue()});
                for (PdfDirectObject glyphWidthObject : glyphWidthObjects) {
                    Integer code;
                    int glyphWidth = (Integer)((PdfInteger)glyphWidthObject).getRawValue();
                    if (glyphWidth > 0 && (code = (Integer)this.codes.get(charCode)) != null) {
                        this.glyphWidths.put((Integer)this.glyphIndexes.get(code), glyphWidth);
                    }
                    charCode.data[0] = (byte)(charCode.data[0] + 1);
                }
            }
        }
        if ((descriptor = this.getDescriptor()) != null) {
            IPdfNumber defaultGlyphWidthObject = (IPdfNumber)((Object)descriptor.get(PdfName.MissingWidth));
            this.defaultGlyphWidth = defaultGlyphWidthObject == null ? 0 : (int)Math.round(defaultGlyphWidthObject.getNumberValue());
        }
    }
}

