/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.documents.contents.fonts.GlyphMapping;
import it.stefanochizzolini.clown.util.ByteArray;
import java.io.EOFException;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PfbParser {
    private IInputStream stream;

    PfbParser(IInputStream stream) {
        this.stream = stream;
    }

    public Map<ByteArray, Integer> parse() {
        Hashtable<ByteArray, Integer> codes;
        block6: {
            codes = new Hashtable<ByteArray, Integer>();
            Pattern linePattern = Pattern.compile("(\\S+)\\s+(.+)");
            try {
                String line;
                while ((line = this.stream.readLine()) != null) {
                    String encodingLine;
                    String key;
                    Matcher lineMatcher = linePattern.matcher(line);
                    if (!lineMatcher.find() || !(key = lineMatcher.group(1)).equals("/Encoding")) continue;
                    this.stream.readLine();
                    Pattern encodingLinePattern = Pattern.compile("dup (\\S+) (\\S+) put");
                    while ((encodingLine = this.stream.readLine()) != null) {
                        Matcher encodingLineMatcher = encodingLinePattern.matcher(encodingLine);
                        if (encodingLineMatcher.find()) {
                            byte[] inputCode = new byte[]{(byte)Integer.parseInt(encodingLineMatcher.group(1))};
                            String name = encodingLineMatcher.group(2).substring(1);
                            codes.put(new ByteArray(inputCode), GlyphMapping.nameToCode(name));
                            continue;
                        }
                        break block6;
                    }
                    break;
                }
            }
            catch (EOFException lineMatcher) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return codes;
    }
}

