/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.documents.contents.fonts.FontFileFormatException;
import java.util.Hashtable;
import java.util.Map;

final class OpenFontParser {
    private static final String Encoding_Latin1 = "ISO-8859-1";
    private static final String Encoding_Unicode = "UTF-16";
    private static final int MicrosoftLanguage_UsEnglish = 1033;
    private static final int NameID_FontPostscriptName = 6;
    private static final int PlatformID_Unicode = 0;
    private static final int PlatformID_Macintosh = 1;
    private static final int PlatformID_Microsoft = 3;
    public FontMetrics metrics;
    public String fontName;
    public OutlineFormatEnum outlineFormat;
    public boolean symbolic;
    public Map<Integer, Integer> glyphIndexes;
    public Map<Integer, Integer> glyphKernings;
    public Map<Integer, Integer> glyphWidths;
    public IInputStream fontData;
    private Map<String, Integer> tableOffsets;

    public static boolean isOpenFont(IInputStream fontData) {
        long position = fontData.getPosition();
        try {
            fontData.setPosition(0L);
            OpenFontParser.getOutlineFormat(fontData.readInt());
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            fontData.setPosition(position);
        }
    }

    private static OutlineFormatEnum getOutlineFormat(int versionCode) {
        switch (versionCode) {
            case 65536: 
            case 1953658213: {
                return OutlineFormatEnum.TrueType;
            }
            case 0x4F54544F: {
                return OutlineFormatEnum.CFF;
            }
        }
        throw new UnsupportedOperationException("Unknown OpenFont format version.");
    }

    OpenFontParser(IInputStream fontData) {
        this.fontData = fontData;
        this.load();
    }

    private void load() {
        this.metrics = new FontMetrics();
        try {
            this.fontData.seek(0L);
            this.outlineFormat = OpenFontParser.getOutlineFormat(this.fontData.readInt());
            int tableCount = this.fontData.readUnsignedShort();
            this.tableOffsets = new Hashtable<String, Integer>(tableCount);
            this.fontData.skip(6L);
            int index = 0;
            while (index < tableCount) {
                String tag = this.readString_ascii(4);
                this.fontData.skip(4L);
                int offset = this.fontData.readInt();
                this.tableOffsets.put(tag, offset);
                this.fontData.skip(4L);
                ++index;
            }
            this.fontName = this.load_getName(6);
            this.load_tables();
            this.load_cMap();
            this.load_glyphWidths();
            this.load_glyphKerning();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void load_cMap() throws FontFileFormatException {
        int format;
        Integer tableOffset = this.tableOffsets.get("cmap");
        if (tableOffset == null) {
            throw new FontFileFormatException("'cmap' table does NOT exist.");
        }
        int cmap10Offset = 0;
        int cmap31Offset = 0;
        try {
            this.fontData.seek(tableOffset + 2);
            int tableCount = this.fontData.readUnsignedShort();
            int tableIndex = 0;
            while (tableIndex < tableCount) {
                int platformID = this.fontData.readUnsignedShort();
                int encodingID = this.fontData.readUnsignedShort();
                int offset = this.fontData.readInt();
                block2 : switch (platformID) {
                    case 1: {
                        switch (encodingID) {
                            case 0: {
                                cmap10Offset = offset;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (encodingID) {
                            case 0: {
                                break block2;
                            }
                            case 1: {
                                cmap31Offset = offset;
                            }
                        }
                    }
                }
                ++tableIndex;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (cmap31Offset > 0) {
            this.metrics.isCustomEncoding = false;
            this.fontData.seek(tableOffset + cmap31Offset);
        } else if (cmap10Offset > 0) {
            this.metrics.isCustomEncoding = true;
            this.fontData.seek(tableOffset + cmap10Offset);
        } else {
            throw new FontFileFormatException("CMAP table unavailable.");
        }
        try {
            format = this.fontData.readUnsignedShort();
        }
        catch (Exception e) {
            throw new FontFileFormatException("Cmap table format not found.", e, this.fontData.getPosition());
        }
        switch (format) {
            case 0: {
                this.load_cMap_format0();
                break;
            }
            case 4: {
                this.load_cMap_format4();
                break;
            }
            case 6: {
                this.load_cMap_format6();
                break;
            }
            default: {
                throw new FontFileFormatException("Cmap table format " + format + " NOT supported.");
            }
        }
    }

    private void load_cMap_format0() throws FontFileFormatException {
        this.symbolic = true;
        this.glyphIndexes = new Hashtable<Integer, Integer>(256);
        try {
            this.fontData.skip(4L);
            int code = 0;
            while (code < 256) {
                this.glyphIndexes.put(code, this.fontData.readUnsignedByte());
                ++code;
            }
        }
        catch (Exception e) {
            throw new FontFileFormatException("Cmap data retrieval failed.", e, this.fontData.getPosition());
        }
    }

    private void load_cMap_format4() throws FontFileFormatException {
        this.symbolic = false;
        try {
            int tableLength = this.fontData.readUnsignedShort();
            this.fontData.skip(2L);
            int segmentCount = this.fontData.readUnsignedShort() / 2;
            this.fontData.skip(6L);
            int[] endCodes = new int[segmentCount];
            int index = 0;
            while (index < segmentCount) {
                endCodes[index] = this.fontData.readUnsignedShort();
                ++index;
            }
            this.fontData.skip(2L);
            int[] startCodes = new int[segmentCount];
            int index2 = 0;
            while (index2 < segmentCount) {
                startCodes[index2] = this.fontData.readUnsignedShort();
                ++index2;
            }
            short[] deltas = new short[segmentCount];
            int index3 = 0;
            while (index3 < segmentCount) {
                deltas[index3] = this.fontData.readShort();
                ++index3;
            }
            int[] rangeOffsets = new int[segmentCount];
            int index4 = 0;
            while (index4 < segmentCount) {
                rangeOffsets[index4] = this.fontData.readUnsignedShort();
                ++index4;
            }
            int glyphIndexCount = tableLength / 2 - 8 - segmentCount * 4;
            int[] glyphIds = new int[glyphIndexCount];
            int index5 = 0;
            while (index5 < glyphIds.length) {
                glyphIds[index5] = this.fontData.readUnsignedShort();
                ++index5;
            }
            this.glyphIndexes = new Hashtable<Integer, Integer>(glyphIndexCount);
            int segmentIndex = 0;
            while (segmentIndex < segmentCount) {
                int endCode = endCodes[segmentIndex];
                if (endCode < 65535) {
                    ++endCode;
                }
                int code = startCodes[segmentIndex];
                while (code < endCode) {
                    int glyphIndex;
                    if (rangeOffsets[segmentIndex] == 0) {
                        glyphIndex = code + deltas[segmentIndex] & 0xFFFF;
                    } else {
                        int glyphIdIndex = rangeOffsets[segmentIndex] / 2 + (code - startCodes[segmentIndex]) - (segmentCount - segmentIndex);
                        glyphIndex = glyphIds[glyphIdIndex] + deltas[segmentIndex] & 0xFFFF;
                    }
                    this.glyphIndexes.put(code, glyphIndex);
                    ++code;
                }
                ++segmentIndex;
            }
        }
        catch (Exception e) {
            throw new FontFileFormatException("Cmap data retrieval failed.", e, this.fontData.getPosition());
        }
    }

    private void load_cMap_format6() throws FontFileFormatException {
        this.symbolic = true;
        try {
            this.fontData.skip(4L);
            int firstCode = this.fontData.readUnsignedShort();
            int codeCount = this.fontData.readUnsignedShort();
            this.glyphIndexes = new Hashtable<Integer, Integer>(codeCount);
            int code = firstCode;
            int lastCode = firstCode + codeCount;
            while (code < lastCode) {
                this.glyphIndexes.put(code, this.fontData.readUnsignedShort());
                ++code;
            }
        }
        catch (Exception e) {
            throw new FontFileFormatException("Cmap data retrieval failed.", e, this.fontData.getPosition());
        }
    }

    private String load_getName(int id) throws FontFileFormatException {
        Integer tableOffset = this.tableOffsets.get("name");
        if (tableOffset == null) {
            throw new FontFileFormatException("'name' table does NOT exist.");
        }
        try {
            this.fontData.seek(tableOffset + 2);
            int recordCount = this.fontData.readUnsignedShort();
            int storageOffset = this.fontData.readUnsignedShort();
            int recordIndex = 0;
            while (recordIndex < recordCount) {
                int platformID = this.fontData.readUnsignedShort();
                if (platformID == 3) {
                    this.fontData.skip(2L);
                    int languageID = this.fontData.readUnsignedShort();
                    if (languageID == 1033) {
                        int nameID = this.fontData.readUnsignedShort();
                        if (nameID == id) {
                            int length = this.fontData.readUnsignedShort();
                            int offset = this.fontData.readUnsignedShort();
                            this.fontData.seek(tableOffset + storageOffset + offset);
                            return this.readString(length, platformID);
                        }
                        this.fontData.skip(4L);
                    } else {
                        this.fontData.skip(6L);
                    }
                } else {
                    this.fontData.skip(10L);
                }
                ++recordIndex;
            }
            return null;
        }
        catch (Exception e) {
            throw new FontFileFormatException("Name '" + id + "' not found.", e, this.fontData.getPosition());
        }
    }

    private void load_glyphKerning() throws FontFileFormatException {
        Integer tableOffset = this.tableOffsets.get("kern");
        if (tableOffset == null) {
            return;
        }
        try {
            this.fontData.seek(tableOffset + 2);
            int subtableCount = this.fontData.readUnsignedShort();
            this.glyphKernings = new Hashtable<Integer, Integer>();
            int subtableOffset = (int)this.fontData.getPosition();
            int subtableIndex = 0;
            while (subtableIndex < subtableCount) {
                this.fontData.seek(subtableOffset + 2);
                int length = this.fontData.readUnsignedShort();
                int coverage = this.fontData.readUnsignedShort();
                if ((coverage & 0xFF00) == 0) {
                    int pairCount = this.fontData.readUnsignedShort();
                    this.fontData.skip(6L);
                    int pairIndex = 0;
                    while (pairIndex < pairCount) {
                        int pair = this.fontData.readInt();
                        int value = (int)((float)this.fontData.readShort() * this.metrics.unitNorm);
                        this.glyphKernings.put(pair, value);
                        ++pairIndex;
                    }
                }
                subtableOffset += length;
                ++subtableIndex;
            }
        }
        catch (Exception e) {
            throw new FontFileFormatException("Glyph kernings retrieval failed.", e, this.fontData.getPosition());
        }
    }

    private void load_glyphWidths() throws FontFileFormatException {
        Integer tableOffset = this.tableOffsets.get("hmtx");
        if (tableOffset == null) {
            throw new FontFileFormatException("'hmtx' table does NOT exist.");
        }
        try {
            this.fontData.seek(tableOffset.intValue());
            this.glyphWidths = new Hashtable<Integer, Integer>(this.metrics.numberOfHMetrics);
            int index = 0;
            while (index < this.metrics.numberOfHMetrics) {
                this.glyphWidths.put(index, (int)((float)this.fontData.readUnsignedShort() * this.metrics.unitNorm));
                this.fontData.skip(2L);
                ++index;
            }
        }
        catch (Exception e) {
            throw new FontFileFormatException("Glyph widths retrieval failed.", e, this.fontData.getPosition());
        }
    }

    private void load_tables() throws FontFileFormatException {
        Integer tableOffset = this.tableOffsets.get("head");
        if (tableOffset == null) {
            throw new FontFileFormatException("'head' table does NOT exist.");
        }
        try {
            this.fontData.seek(tableOffset + 16);
            this.metrics.flags = this.fontData.readUnsignedShort();
            this.metrics.unitsPerEm = this.fontData.readUnsignedShort();
            this.metrics.unitNorm = 1000.0f / (float)this.metrics.unitsPerEm;
            this.fontData.skip(16L);
            this.metrics.xMin = this.fontData.readShort();
            this.metrics.yMin = this.fontData.readShort();
            this.metrics.xMax = this.fontData.readShort();
            this.metrics.yMax = this.fontData.readShort();
            this.metrics.macStyle = this.fontData.readUnsignedShort();
        }
        catch (Exception e) {
            throw new FontFileFormatException("'head' metrics retrieval failed.", e, this.fontData.getPosition());
        }
        tableOffset = this.tableOffsets.get("OS/2");
        if (tableOffset != null) {
            try {
                this.fontData.seek(tableOffset.intValue());
                int version = this.fontData.readUnsignedShort();
                this.fontData.skip(66L);
                this.metrics.sTypoAscender = this.fontData.readShort();
                this.metrics.sTypoDescender = this.fontData.readShort();
                this.metrics.sTypoLineGap = this.fontData.readShort();
                if (version >= 2) {
                    this.fontData.skip(12L);
                    this.metrics.sxHeight = this.fontData.readShort();
                    this.metrics.sCapHeight = this.fontData.readShort();
                } else {
                    this.metrics.sxHeight = (short)(0.5 * (double)this.metrics.unitsPerEm);
                    this.metrics.sCapHeight = (short)(0.7 * (double)this.metrics.unitsPerEm);
                }
            }
            catch (Exception e) {
                throw new FontFileFormatException("'OS/2' metrics retrieval failed.", e, this.fontData.getPosition());
            }
        }
        if ((tableOffset = this.tableOffsets.get("hhea")) == null) {
            throw new FontFileFormatException("'hhea' table does NOT exist.");
        }
        try {
            this.fontData.seek(tableOffset + 4);
            this.metrics.ascender = this.fontData.readShort();
            this.metrics.descender = this.fontData.readShort();
            this.metrics.lineGap = this.fontData.readShort();
            this.metrics.advanceWidthMax = this.fontData.readUnsignedShort();
            this.metrics.minLeftSideBearing = this.fontData.readShort();
            this.metrics.minRightSideBearing = this.fontData.readShort();
            this.metrics.xMaxExtent = this.fontData.readShort();
            this.metrics.caretSlopeRise = this.fontData.readShort();
            this.metrics.caretSlopeRun = this.fontData.readShort();
            this.fontData.skip(12L);
            this.metrics.numberOfHMetrics = this.fontData.readUnsignedShort();
        }
        catch (Exception e) {
            throw new FontFileFormatException("'hhea' metrics retrieval failed.", e, this.fontData.getPosition());
        }
        tableOffset = this.tableOffsets.get("post");
        if (tableOffset == null) {
            throw new FontFileFormatException("'post' table does NOT exist.");
        }
        try {
            this.fontData.seek(tableOffset + 4);
            this.metrics.italicAngle = (float)this.fontData.readShort() + (float)this.fontData.readUnsignedShort() / 16384.0f;
            this.metrics.underlinePosition = this.fontData.readShort();
            this.metrics.underlineThickness = this.fontData.readShort();
            this.metrics.isFixedPitch = this.fontData.readInt() != 0;
        }
        catch (Exception e) {
            throw new FontFileFormatException("'post' metrics retrieval failed.", e, this.fontData.getPosition());
        }
    }

    private String readString(int length, int platformID) {
        switch (platformID) {
            case 0: 
            case 3: {
                return this.readString_unicode(length);
            }
        }
        return this.readString_ascii(length);
    }

    private String readString_ascii(int length) {
        try {
            byte[] data = new byte[length];
            this.fontData.read(data);
            return new String(data, Encoding_Latin1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readString_unicode(int length) {
        try {
            byte[] data = new byte[length];
            this.fontData.read(data);
            return new String(data, Encoding_Unicode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class FontMetrics {
        public boolean isCustomEncoding;
        public float unitNorm;
        public int flags;
        public int unitsPerEm;
        public short xMin;
        public short yMin;
        public short xMax;
        public short yMax;
        public int macStyle;
        public short ascender;
        public short descender;
        public short lineGap;
        public int advanceWidthMax;
        public short minLeftSideBearing;
        public short minRightSideBearing;
        public short xMaxExtent;
        public short caretSlopeRise;
        public short caretSlopeRun;
        public int numberOfHMetrics;
        public short sTypoAscender;
        public short sTypoDescender;
        public short sTypoLineGap;
        public short sxHeight;
        public short sCapHeight;
        public float italicAngle;
        public short underlinePosition;
        public short underlineThickness;
        public boolean isFixedPitch;

        FontMetrics() {
        }
    }

    static enum OutlineFormatEnum {
        TrueType,
        CFF;

    }
}

