/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.bytes.Buffer;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.fonts.CMap;
import it.stefanochizzolini.clown.documents.contents.fonts.Font;
import it.stefanochizzolini.clown.documents.contents.fonts.OpenFontParser;
import it.stefanochizzolini.clown.documents.contents.fonts.Type0Font;
import it.stefanochizzolini.clown.documents.contents.fonts.Type2Font;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfStream;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.objects.Rectangle;
import it.stefanochizzolini.clown.util.BiMap;
import it.stefanochizzolini.clown.util.ByteArray;
import it.stefanochizzolini.clown.util.ConvertUtils;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public abstract class CompositeFont
extends Font {
    private static final String HexPadding = "0000";

    public static CompositeFont get(Document context, IInputStream fontData) {
        OpenFontParser parser = new OpenFontParser(fontData);
        switch (parser.outlineFormat) {
            case CFF: {
                return new Type0Font(context, parser);
            }
            case TrueType: {
                return new Type2Font(context, parser);
            }
        }
        throw new UnsupportedOperationException("Unknown composite font format.");
    }

    private static String getHex(int value) {
        String hex = Integer.toHexString(value);
        return String.valueOf(HexPadding.substring(hex.length())) + hex;
    }

    protected CompositeFont(Document context, OpenFontParser parser) {
        super(context);
        this.load(parser);
    }

    protected CompositeFont(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public CompositeFont clone(Document context) {
        throw new NotImplementedException();
    }

    protected PdfDictionary getCIDFontDictionary() {
        return (PdfDictionary)((PdfArray)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.DescendantFonts)).resolve(0);
    }

    @Override
    protected PdfDictionary getDescriptor() {
        return (PdfDictionary)this.getCIDFontDictionary().resolve(PdfName.FontDescriptor);
    }

    protected void loadEncoding() {
        PdfDataObject encodingObject = ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Encoding);
        Map<ByteArray, Integer> cmap = CMap.get(encodingObject);
        if (this.codes == null) {
            this.codes = new BiMap();
            if (encodingObject instanceof PdfName && !encodingObject.equals(PdfName.IdentityH) && !encodingObject.equals(PdfName.IdentityV)) {
                PdfDictionary cidSystemInfo = (PdfDictionary)this.getCIDFontDictionary().resolve(PdfName.CIDSystemInfo);
                String registry = (String)((PdfTextString)cidSystemInfo.get(PdfName.Registry)).getValue();
                String ordering = (String)((PdfTextString)cidSystemInfo.get(PdfName.Ordering)).getValue();
                String ucs2CMapName = String.valueOf(registry) + "-" + ordering + "-" + "UCS2";
                BiMap<ByteArray, Integer> ucs2CMap = new BiMap<ByteArray, Integer>(CMap.get(ucs2CMapName));
                if (!ucs2CMap.isEmpty()) {
                    for (Map.Entry<ByteArray, Integer> cmapEntry : cmap.entrySet()) {
                        this.codes.put(cmapEntry.getKey(), ConvertUtils.byteArrayToInt(ucs2CMap.getKey((Integer)cmapEntry.getValue()).data));
                    }
                }
            }
            if (this.codes.isEmpty()) {
                this.symbolic = true;
                for (Map.Entry<ByteArray, Integer> cmapEntry : cmap.entrySet()) {
                    this.codes.put(cmapEntry.getKey(), ConvertUtils.byteArrayToInt(cmapEntry.getKey().data));
                }
            }
        }
        this.glyphIndexes = new Hashtable();
        for (Map.Entry<ByteArray, Integer> cmapEntry : cmap.entrySet()) {
            if (!this.codes.containsKey(cmapEntry.getKey())) continue;
            this.glyphIndexes.put((Integer)this.codes.get(cmapEntry.getKey()), cmapEntry.getValue());
        }
    }

    @Override
    protected void onLoad() {
        PdfInteger defaultGlyphWidthObject;
        this.loadEncoding();
        this.glyphWidths = new Hashtable();
        PdfArray glyphWidthObjects = (PdfArray)this.getCIDFontDictionary().resolve(PdfName.W);
        if (glyphWidthObjects != null) {
            Iterator<PdfDirectObject> iterator = glyphWidthObjects.iterator();
            while (iterator.hasNext()) {
                int startCID = (Integer)((PdfInteger)iterator.next()).getRawValue();
                PdfDirectObject glyphWidthObject2 = iterator.next();
                if (glyphWidthObject2 instanceof PdfArray) {
                    int cID = startCID;
                    for (PdfDirectObject glyphWidthObject : (PdfArray)glyphWidthObject2) {
                        this.glyphWidths.put(cID++, (Integer)((PdfInteger)glyphWidthObject).getRawValue());
                    }
                    continue;
                }
                int endCID = (Integer)((PdfInteger)glyphWidthObject2).getRawValue();
                int glyphWidth = (Integer)((PdfInteger)iterator.next()).getRawValue();
                int cID = startCID;
                while (cID <= endCID) {
                    this.glyphWidths.put(cID, glyphWidth);
                    ++cID;
                }
            }
        }
        this.defaultGlyphWidth = (defaultGlyphWidthObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.W)) == null ? 0 : (Integer)defaultGlyphWidthObject.getRawValue();
    }

    private void load(OpenFontParser parser) {
        try {
            PdfName subType;
            this.glyphIndexes = parser.glyphIndexes;
            this.glyphKernings = parser.glyphKernings;
            this.glyphWidths = parser.glyphWidths;
            PdfDictionary baseDataObject = (PdfDictionary)this.getBaseDataObject();
            baseDataObject.put(PdfName.BaseFont, new PdfName(parser.fontName));
            baseDataObject.put(PdfName.Subtype, PdfName.Type0);
            baseDataObject.put(PdfName.Encoding, PdfName.IdentityH);
            PdfDictionary cidFontDictionary = new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Font});
            switch (parser.outlineFormat) {
                case TrueType: {
                    subType = PdfName.CIDFontType2;
                    break;
                }
                case CFF: {
                    subType = PdfName.CIDFontType0;
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
            cidFontDictionary.put(PdfName.Subtype, subType);
            cidFontDictionary.put(PdfName.BaseFont, new PdfName(parser.fontName));
            cidFontDictionary.put(PdfName.CIDSystemInfo, new PdfDictionary(new PdfName[]{PdfName.Registry, PdfName.Ordering, PdfName.Supplement}, new PdfDirectObject[]{new PdfTextString("Adobe"), new PdfTextString("Identity"), new PdfInteger(0)}));
            cidFontDictionary.put(PdfName.FontDescriptor, this.load_createFontDescriptor(parser));
            this.load_createEncoding(baseDataObject, cidFontDictionary);
            baseDataObject.put(PdfName.DescendantFonts, new PdfArray(this.getFile().register(cidFontDictionary)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.load();
    }

    private void load_createEncoding(PdfDictionary font, PdfDictionary cidFont) {
        Buffer cmapBuffer = new Buffer();
        cmapBuffer.append("%!PS-Adobe-3.0 Resource-CMap\n%%DocumentNeededResources: ProcSet (CIDInit)\n%%IncludeResource: ProcSet (CIDInit)\n%%BeginResource: CMap (Adobe-Identity-UCS)\n%%Title: (Adobe-Identity-UCS Adobe Identity 0)\n%%Version: 1\n%%EndComments\n/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n3 dict dup begin\n/Registry (Adobe) def\n/Ordering (Identity) def\n/Supplement 0 def\nend def\n/CMapName /Adobe-Identity-UCS def\n/CMapVersion 1 def\n/CMapType 0 def\n/WMode 0 def\n2 begincodespacerange\n<20> <20>\n<0000> <19FF>\nendcodespacerange\n" + this.glyphIndexes.size() + " begincidchar\n");
        Buffer toUnicodeBuffer = new Buffer();
        toUnicodeBuffer.append("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapVersion 10.001 def\n/CMapType 2 def\n2 begincodespacerange\n<20> <20>\n<0000> <19FF>\nendcodespacerange\n" + this.glyphIndexes.size() + " beginbfchar\n");
        Buffer gIdBuffer = new Buffer();
        gIdBuffer.append((byte)0);
        gIdBuffer.append((byte)0);
        int code = 0;
        this.codes = new BiMap(this.glyphIndexes.size());
        PdfArray widthsObject = new PdfArray(this.glyphWidths.size());
        for (Map.Entry glyphIndexEntry : this.glyphIndexes.entrySet()) {
            int width;
            byte[] byArray;
            ++code;
            if ((Integer)glyphIndexEntry.getKey() == 32) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 32;
            } else {
                byte[] byArray3 = new byte[2];
                byArray3[0] = (byte)(code >> 8 & 0xFF);
                byArray = byArray3;
                byArray3[1] = (byte)(code & 0xFF);
            }
            byte[] charCode = byArray;
            this.codes.put(new ByteArray(charCode), (Integer)glyphIndexEntry.getKey());
            cmapBuffer.append("<");
            toUnicodeBuffer.append("<");
            int charCodeBytesIndex = 0;
            int charCodeBytesLength = charCode.length;
            while (charCodeBytesIndex < charCodeBytesLength) {
                String hex = Integer.toHexString(charCode[charCodeBytesIndex]);
                hex = hex.length() == 1 ? "0" + hex : hex.substring(hex.length() - 2, hex.length());
                cmapBuffer.append(hex);
                toUnicodeBuffer.append(hex);
                ++charCodeBytesIndex;
            }
            cmapBuffer.append("> " + code + "\n");
            toUnicodeBuffer.append("> <" + CompositeFont.getHex((Integer)glyphIndexEntry.getKey()) + ">\n");
            int glyphIndex = (Integer)glyphIndexEntry.getValue();
            gIdBuffer.append((byte)(glyphIndex >> 8 & 0xFF));
            gIdBuffer.append((byte)(glyphIndex & 0xFF));
            try {
                width = (Integer)this.glyphWidths.get(glyphIndex);
                if (width > 1000) {
                    width = 1000;
                }
            }
            catch (Exception e) {
                width = 0;
            }
            widthsObject.add(new PdfInteger(width));
        }
        cmapBuffer.append("endcidchar\nendcmap\nCMapName currentdict /CMap defineresource pop\nend\nend\n%%EndResource\n%%EOF");
        PdfStream cmapStream = new PdfStream(cmapBuffer);
        PdfDictionary cmapHead = cmapStream.getHeader();
        cmapHead.put(PdfName.Type, PdfName.CMap);
        cmapHead.put(PdfName.CMapName, new PdfName("Adobe-Identity-UCS"));
        cmapHead.put(PdfName.CIDSystemInfo, new PdfDictionary(new PdfName[]{PdfName.Registry, PdfName.Ordering, PdfName.Supplement}, new PdfDirectObject[]{new PdfTextString("Adobe"), new PdfTextString("Identity"), new PdfInteger(0)}));
        font.put(PdfName.Encoding, this.getFile().register(cmapStream));
        PdfStream gIdStream = new PdfStream(gIdBuffer);
        cidFont.put(PdfName.CIDToGIDMap, this.getFile().register(gIdStream));
        cidFont.put(PdfName.W, new PdfArray(new PdfInteger(1), widthsObject));
        toUnicodeBuffer.append("endbfchar\nendcmap\nCMapName currentdict /CMap defineresource pop\nend\nend\n");
        PdfStream toUnicodeStream = new PdfStream(toUnicodeBuffer);
        font.put(PdfName.ToUnicode, this.getFile().register(toUnicodeStream));
    }

    private PdfReference load_createFontDescriptor(OpenFontParser parser) {
        PdfDictionary fontDescriptor = new PdfDictionary();
        OpenFontParser.FontMetrics metrics = parser.metrics;
        fontDescriptor.put(PdfName.Type, PdfName.FontDescriptor);
        fontDescriptor.put(PdfName.FontName, ((PdfDictionary)this.getBaseDataObject()).get(PdfName.BaseFont));
        int flags = 0;
        if (metrics.isFixedPitch) {
            flags |= Font.FlagsEnum.FixedPitch.getCode();
        }
        flags = metrics.isCustomEncoding ? (flags |= Font.FlagsEnum.Symbolic.getCode()) : (flags |= Font.FlagsEnum.Nonsymbolic.getCode());
        fontDescriptor.put(PdfName.Flags, new PdfInteger(flags));
        fontDescriptor.put(PdfName.FontBBox, (PdfDirectObject)new Rectangle(new Point2D.Double((float)metrics.xMin * metrics.unitNorm, (float)metrics.yMin * metrics.unitNorm), new Point2D.Double((float)metrics.xMax * metrics.unitNorm, (float)metrics.yMax * metrics.unitNorm)).getBaseDataObject());
        fontDescriptor.put(PdfName.ItalicAngle, new PdfReal(metrics.italicAngle));
        fontDescriptor.put(PdfName.Ascent, new PdfReal(metrics.ascender == 0 ? (float)metrics.sTypoAscender * metrics.unitNorm : (float)metrics.ascender * metrics.unitNorm));
        fontDescriptor.put(PdfName.Descent, new PdfReal(metrics.descender == 0 ? (float)metrics.sTypoDescender * metrics.unitNorm : (float)metrics.descender * metrics.unitNorm));
        fontDescriptor.put(PdfName.Leading, new PdfReal((float)metrics.sTypoLineGap * metrics.unitNorm));
        fontDescriptor.put(PdfName.CapHeight, new PdfReal((float)metrics.sCapHeight * metrics.unitNorm));
        fontDescriptor.put(PdfName.StemV, new PdfInteger(100));
        PdfReference fontFileReference = this.getFile().register(new PdfStream(new PdfDictionary(new PdfName[]{PdfName.Subtype}, new PdfDirectObject[]{PdfName.OpenType}), new Buffer(parser.fontData.toByteArray())));
        fontDescriptor.put(PdfName.FontFile3, fontFileReference);
        return this.getFile().register(fontDescriptor);
    }

    public static /* bridge */ /* synthetic */ Font get(Document document, IInputStream iInputStream) {
        return CompositeFont.get(document, iInputStream);
    }
}

