/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.fonts;

import it.stefanochizzolini.clown.bytes.Buffer;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.documents.contents.fonts.CMapParser;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfStream;
import it.stefanochizzolini.clown.util.ByteArray;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;

final class CMap {
    public static Map<ByteArray, Integer> get(IInputStream stream) {
        CMapParser parser = new CMapParser(stream);
        return parser.parse();
    }

    public static Map<ByteArray, Integer> get(PdfDataObject encodingObject) {
        if (encodingObject == null) {
            return null;
        }
        if (encodingObject instanceof PdfName) {
            return CMap.get((PdfName)encodingObject);
        }
        if (encodingObject instanceof PdfStream) {
            return CMap.get((PdfStream)encodingObject);
        }
        throw new UnsupportedOperationException("Unknown encoding object type: " + encodingObject.getClass().getSimpleName());
    }

    public static Map<ByteArray, Integer> get(PdfStream stream) {
        return CMap.get(stream.getBody());
    }

    public static Map<ByteArray, Integer> get(PdfName name) {
        return CMap.get((String)name.getValue());
    }

    public static Map<ByteArray, Integer> get(String name) {
        Map<ByteArray, Integer> cmap = null;
        BufferedReader cmapStream = null;
        try {
            try {
                cmapStream = new BufferedReader(new InputStreamReader(CMap.class.getResourceAsStream("/fonts/cmap/" + name)));
                cmap = CMap.get(new Buffer(cmapStream));
            }
            catch (Exception exception) {
                try {
                    if (cmapStream != null) {
                        cmapStream.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (cmapStream != null) {
                    cmapStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return cmap;
    }

    private CMap() {
    }
}

