/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.entities;

import it.stefanochizzolini.clown.bytes.Buffer;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.composition.PrimitiveFilter;
import it.stefanochizzolini.clown.documents.contents.entities.Image;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.objects.InlineImage;
import it.stefanochizzolini.clown.documents.contents.objects.InlineImageBody;
import it.stefanochizzolini.clown.documents.contents.objects.InlineImageHeader;
import it.stefanochizzolini.clown.documents.contents.xObjects.ImageXObject;
import it.stefanochizzolini.clown.documents.contents.xObjects.XObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfStream;
import java.nio.ByteOrder;
import java.util.Arrays;

public class JpegImage
extends Image {
    JpegImage(IInputStream stream) {
        super(stream);
        this.load();
    }

    @Override
    public ContentObject toInlineObject(PrimitiveFilter context) {
        return context.add(new InlineImage(new InlineImageHeader(Arrays.asList(PdfName.W, new PdfInteger(this.getWidth()), PdfName.H, new PdfInteger(this.getHeight()), PdfName.CS, PdfName.RGB, PdfName.BPC, new PdfInteger(this.getBitsPerComponent()), PdfName.F, PdfName.DCT)), new InlineImageBody(new Buffer(this.getStream().toByteArray()))));
    }

    @Override
    public XObject toXObject(Document context) {
        return new ImageXObject(context, new PdfStream(new PdfDictionary(new PdfName[]{PdfName.Width, PdfName.Height, PdfName.BitsPerComponent, PdfName.ColorSpace, PdfName.Filter}, new PdfDirectObject[]{new PdfInteger(this.getWidth()), new PdfInteger(this.getHeight()), new PdfInteger(this.getBitsPerComponent()), PdfName.DeviceRGB, PdfName.DCTDecode}), new Buffer(this.getStream().toByteArray())));
    }

    private void load() {
        IInputStream stream = this.getStream();
        stream.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            int index = 4;
            stream.seek(index);
            byte[] markerBytes = new byte[2];
            do {
                stream.seek(index += stream.readUnsignedShort());
                stream.read(markerBytes);
                index += 2;
            } while (markerBytes[0] != -1 || markerBytes[1] != -64);
            stream.skip(2L);
            this.setBitsPerComponent(stream.readUnsignedByte());
            this.setHeight(stream.readUnsignedShort());
            this.setWidth(stream.readUnsignedShort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

