/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.entities;

import it.stefanochizzolini.clown.bytes.FileInputStream;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.documents.contents.entities.Entity;
import it.stefanochizzolini.clown.documents.contents.entities.JpegImage;
import java.io.File;
import java.io.RandomAccessFile;

public abstract class Image
extends Entity {
    private int bitsPerComponent;
    private int height;
    private int width;
    private IInputStream stream;

    public static Image get(String path) {
        try {
            return Image.get(new FileInputStream(new RandomAccessFile(path, "r")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Image get(File file) {
        return Image.get(file.getPath());
    }

    public static Image get(IInputStream stream) {
        try {
            byte[] formatMarkerBytes = new byte[2];
            stream.read(formatMarkerBytes);
            if (formatMarkerBytes[0] == -1 && formatMarkerBytes[1] == -40) {
                return new JpegImage(stream);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Image(IInputStream stream) {
        this.stream = stream;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected IInputStream getStream() {
        return this.stream;
    }

    protected void setBitsPerComponent(int value) {
        this.bitsPerComponent = value;
    }

    protected void setHeight(int value) {
        this.height = value;
    }

    protected void setWidth(int value) {
        this.width = value;
    }
}

