/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.entities;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.composition.PrimitiveFilter;
import it.stefanochizzolini.clown.documents.contents.entities.Barcode;
import it.stefanochizzolini.clown.documents.contents.fonts.StandardType1Font;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.objects.LocalGraphicsState;
import it.stefanochizzolini.clown.documents.contents.xObjects.FormXObject;
import it.stefanochizzolini.clown.documents.contents.xObjects.XObject;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class EAN13Barcode
extends Barcode {
    private static final int[][] DigitElementWidths = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    private static int ElementCount;
    private static final int DigitHeight;
    private static final int DigitWidth;
    private static final int BarHeight;
    private static final int DigitGlyphWidth;
    private static final float[] DigitGlyphXs;
    private static int[] GuardBarIndexes;
    private static final int NumberSet_A = 0;
    private static final int NumberSet_B = 1;
    private static final int[][] LeftHalfNumberSets;

    static {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 28;
        nArray[3] = 30;
        nArray[4] = 56;
        nArray[5] = 58;
        GuardBarIndexes = nArray;
        int[][] nArrayArray = new int[10][];
        nArrayArray[0] = new int[6];
        int[] nArray2 = new int[6];
        nArray2[2] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[6];
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[5] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[6];
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[6];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArray6[5] = 1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[6];
        nArray8[1] = 1;
        nArray8[3] = 1;
        nArray8[5] = 1;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[6];
        nArray9[1] = 1;
        nArray9[3] = 1;
        nArray9[4] = 1;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[6];
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArray10[4] = 1;
        nArrayArray[9] = nArray10;
        LeftHalfNumberSets = nArrayArray;
        int[] digitElementWidths = DigitElementWidths[0];
        ElementCount = 3 + digitElementWidths.length * 6 + 5 + digitElementWidths.length * 6 + 3;
        int digitWidth = 0;
        int[] nArray11 = digitElementWidths;
        int n = digitElementWidths.length;
        int n2 = 0;
        while (n2 < n) {
            int digitElementWidth = nArray11[n2];
            digitWidth += digitElementWidth;
            ++n2;
        }
        DigitWidth = digitWidth;
        DigitHeight = DigitWidth + 2;
        DigitGlyphWidth = DigitWidth - 1;
        BarHeight = DigitHeight * 4;
        float[] elementWidths = new float[]{DigitWidth, 3.0f, DigitWidth, DigitWidth, DigitWidth, DigitWidth, DigitWidth, DigitWidth, 5.0f, DigitWidth, DigitWidth, DigitWidth, DigitWidth, DigitWidth, DigitWidth, 3.0f};
        int[] nArray12 = new int[13];
        nArray12[1] = 2;
        nArray12[2] = 3;
        nArray12[3] = 4;
        nArray12[4] = 5;
        nArray12[5] = 6;
        nArray12[6] = 7;
        nArray12[7] = 9;
        nArray12[8] = 10;
        nArray12[9] = 11;
        nArray12[10] = 12;
        nArray12[11] = 13;
        nArray12[12] = 14;
        int[] digitIndexes = nArray12;
        DigitGlyphXs = new float[13];
        int digitXIndex = 0;
        int index = 0;
        int length = elementWidths.length;
        while (index < length) {
            if (index < digitIndexes[digitXIndex]) {
                int n3 = digitXIndex;
                DigitGlyphXs[n3] = DigitGlyphXs[n3] + elementWidths[index];
            } else {
                int n4 = digitXIndex++;
                DigitGlyphXs[n4] = DigitGlyphXs[n4] + elementWidths[index] / 2.0f;
                if (digitXIndex >= DigitGlyphXs.length) break;
                EAN13Barcode.DigitGlyphXs[digitXIndex] = DigitGlyphXs[digitXIndex - 1] + elementWidths[index] / 2.0f;
            }
            ++index;
        }
    }

    public EAN13Barcode(String code) {
        super(code);
    }

    @Override
    public ContentObject toInlineObject(PrimitiveFilter context) {
        LocalGraphicsState barcodeObject = context.beginLocalState();
        StandardType1Font font = new StandardType1Font(context.getScanner().getContents().getDocument(), StandardType1Font.FamilyEnum.Helvetica, false, false);
        float fontSize = (float)((double)DigitGlyphWidth / font.getWidth(this.code.substring(0, 1), 1.0));
        float elementX = DigitWidth;
        int[] elementWidths = this.getElementWidths();
        float guardBarIndentY = DigitHeight / 2;
        boolean isBar = true;
        int elementIndex = 0;
        while (elementIndex < elementWidths.length) {
            float elementWidth = elementWidths[elementIndex];
            if (isBar) {
                context.drawRectangle(new Rectangle2D.Double(elementX, 0.0, elementWidth, (float)BarHeight + (Arrays.binarySearch(GuardBarIndexes, elementIndex) >= 0 ? guardBarIndentY : 0.0f)));
            }
            elementX += elementWidth;
            isBar = !isBar;
            ++elementIndex;
        }
        context.fill();
        context.setFont(font, (double)fontSize);
        float digitY = (float)BarHeight + ((float)DigitHeight - (float)font.getAscent(fontSize)) / 2.0f;
        int digitIndex = 0;
        while (digitIndex < 13) {
            String digit = this.code.substring(digitIndex, digitIndex + 1);
            float pX = DigitGlyphXs[digitIndex] - (float)font.getWidth(digit, (double)fontSize) / 2.0f;
            context.showText(digit, new Point2D.Double(pX, digitY));
            ++digitIndex;
        }
        context.end();
        return barcodeObject;
    }

    @Override
    public XObject toXObject(Document context) {
        FormXObject xObject = new FormXObject(context);
        xObject.setSize(this.getSize());
        PrimitiveFilter builder = new PrimitiveFilter(xObject);
        this.toInlineObject(builder);
        builder.flush();
        return xObject;
    }

    private int[] getElementWidths() {
        int[] digitElementWidths;
        int[] digits = new int[this.code.length()];
        int index = 0;
        while (index < digits.length) {
            digits[index] = this.code.charAt(index) - 48;
            ++index;
        }
        int[] elementWidths = new int[ElementCount];
        int elementIndex = 0;
        elementWidths[elementIndex++] = 1;
        elementWidths[elementIndex++] = 1;
        elementWidths[elementIndex++] = 1;
        int digitIndex = 0;
        int[] leftHalfNumberSets = LeftHalfNumberSets[digits[digitIndex++]];
        do {
            digitElementWidths = DigitElementWidths[digits[digitIndex]];
            if (leftHalfNumberSets[digitIndex - 1] == 0) {
                elementWidths[elementIndex++] = digitElementWidths[0];
                elementWidths[elementIndex++] = digitElementWidths[1];
                elementWidths[elementIndex++] = digitElementWidths[2];
                elementWidths[elementIndex++] = digitElementWidths[3];
                continue;
            }
            elementWidths[elementIndex++] = digitElementWidths[3];
            elementWidths[elementIndex++] = digitElementWidths[2];
            elementWidths[elementIndex++] = digitElementWidths[1];
            elementWidths[elementIndex++] = digitElementWidths[0];
        } while (digitIndex++ < leftHalfNumberSets.length);
        elementWidths[elementIndex++] = 1;
        elementWidths[elementIndex++] = 1;
        elementWidths[elementIndex++] = 1;
        elementWidths[elementIndex++] = 1;
        elementWidths[elementIndex++] = 1;
        do {
            digitElementWidths = DigitElementWidths[digits[digitIndex]];
            elementWidths[elementIndex++] = digitElementWidths[0];
            elementWidths[elementIndex++] = digitElementWidths[1];
            elementWidths[elementIndex++] = digitElementWidths[2];
            elementWidths[elementIndex++] = digitElementWidths[3];
        } while (digitIndex++ < 12);
        elementWidths[elementIndex++] = 1;
        elementWidths[elementIndex++] = 1;
        elementWidths[elementIndex++] = 1;
        return elementWidths;
    }

    private Dimension2D getSize() {
        return new Dimension(DigitWidth * 13 + 6 + 5, BarHeight + DigitHeight);
    }
}

