/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.colorSpaces;

import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceCMYKColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceColor;

public class DeviceCMYKColor
extends DeviceColor {
    public static final DeviceCMYKColor Black = new DeviceCMYKColor(0.0, 0.0, 0.0, 1.0);
    public static final DeviceCMYKColor White = new DeviceCMYKColor(0.0, 0.0, 0.0, 0.0);
    public static final DeviceCMYKColor Default = Black;
    private double blackComponent;
    private double cyanComponent;
    private double magentaComponent;
    private double yellowComponent;

    public DeviceCMYKColor(double cyanComponent, double magentaComponent, double yellowComponent, double blackComponent) {
        super(DeviceCMYKColorSpace.Default);
        this.setCyanComponent(cyanComponent);
        this.setMagentaComponent(magentaComponent);
        this.setYellowComponent(yellowComponent);
        this.setBlackComponent(blackComponent);
    }

    public double getBlackComponent() {
        return this.blackComponent;
    }

    @Override
    public double[] getComponents() {
        return new double[]{this.cyanComponent, this.magentaComponent, this.yellowComponent, this.blackComponent};
    }

    public double getCyanComponent() {
        return this.cyanComponent;
    }

    public double getMagentaComponent() {
        return this.magentaComponent;
    }

    public double getYellowComponent() {
        return this.yellowComponent;
    }

    public void setBlackComponent(double value) {
        this.blackComponent = DeviceCMYKColor.normalizeComponent(value);
    }

    public void setCyanComponent(double value) {
        this.cyanComponent = DeviceCMYKColor.normalizeComponent(value);
    }

    public void setMagentaComponent(double value) {
        this.magentaComponent = DeviceCMYKColor.normalizeComponent(value);
    }

    public void setYellowComponent(double value) {
        this.yellowComponent = DeviceCMYKColor.normalizeComponent(value);
    }
}

