/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.contents.colorSpaces;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.CalGrayColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.CalRGBColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.Color;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceCMYKColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceRGBColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.ICCBasedColorSpace;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.LabColorSpace;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;

public abstract class ColorSpace
extends PdfObjectWrapper<PdfDirectObject> {
    public static ColorSpace wrap(PdfReference reference) {
        return ColorSpace.wrap(reference, null);
    }

    public static ColorSpace wrap(PdfDirectObject baseObject, PdfIndirectObject container) {
        if (baseObject == null) {
            return null;
        }
        PdfDataObject baseDataObject = File.resolve(baseObject);
        PdfName name = baseDataObject instanceof PdfArray ? (PdfName)((PdfArray)baseDataObject).get(0) : (PdfName)baseDataObject;
        if (name.equals(PdfName.DeviceRGB)) {
            return new DeviceRGBColorSpace(baseObject, container);
        }
        if (name.equals(PdfName.DeviceCMYK)) {
            return new DeviceCMYKColorSpace(baseObject, container);
        }
        if (name.equals(PdfName.DeviceGray)) {
            return new DeviceGrayColorSpace(baseObject, container);
        }
        if (name.equals(PdfName.CalRGB)) {
            return new CalRGBColorSpace(baseObject, container);
        }
        if (name.equals(PdfName.CalGray)) {
            return new CalGrayColorSpace(baseObject, container);
        }
        if (name.equals(PdfName.Lab)) {
            return new LabColorSpace(baseObject, container);
        }
        if (name.equals(PdfName.ICCBased)) {
            return new ICCBasedColorSpace(baseObject, container);
        }
        return null;
    }

    protected ColorSpace(Document context, PdfDirectObject baseDataObject) {
        super(context.getFile(), baseDataObject);
    }

    protected ColorSpace(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    public abstract Color getColor(PdfDirectObject[] var1);

    public abstract Color getDefaultColor();
}

