/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class Pages
extends PdfObjectWrapper<PdfDictionary>
implements List<Page> {
    Pages(Document context) {
        super(context.getFile(), new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.Kids, PdfName.Count}, new PdfDirectObject[]{PdfName.Pages, new PdfArray(), new PdfInteger(0)}));
    }

    Pages(PdfDirectObject baseObject) {
        super(baseObject, null);
    }

    @Override
    public Pages clone(Document context) {
        throw new NotImplementedException();
    }

    @Override
    public void add(int index, Page page) {
        this.commonAddAll(index, Arrays.asList(page));
    }

    @Override
    public boolean addAll(int index, Collection<? extends Page> pages) {
        return this.commonAddAll(index, pages);
    }

    @Override
    public Page get(int index) {
        int pageOffset = 0;
        PdfDictionary parent = (PdfDictionary)this.getBaseDataObject();
        PdfArray kids = (PdfArray)File.resolve(parent.get(PdfName.Kids));
        int i = 0;
        while (i < kids.size()) {
            PdfReference kidReference = (PdfReference)kids.get(i);
            PdfDictionary kid = (PdfDictionary)File.resolve(kidReference);
            if (kid.get(PdfName.Type).equals(PdfName.Page)) {
                if (pageOffset == index) {
                    return new Page(kidReference);
                }
                ++pageOffset;
            } else if ((Integer)((PdfInteger)kid.get(PdfName.Count)).getRawValue() + pageOffset > index) {
                parent = kid;
                kids = (PdfArray)File.resolve(parent.get(PdfName.Kids));
                i = -1;
            } else {
                pageOffset += ((Integer)((PdfInteger)kid.get(PdfName.Count)).getRawValue()).intValue();
            }
            ++i;
        }
        return null;
    }

    @Override
    public int indexOf(Object page) {
        return ((Page)page).getIndex();
    }

    @Override
    public int lastIndexOf(Object page) {
        return this.indexOf(page);
    }

    @Override
    public ListIterator<Page> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<Page> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public Page remove(int index) {
        Page page = this.get(index);
        this.remove(page);
        return page;
    }

    @Override
    public Page set(int index, Page page) {
        Page old = this.remove(index);
        this.add(index, page);
        return old;
    }

    @Override
    public List<Page> subList(int fromIndex, int toIndex) {
        ArrayList<Page> pages = new ArrayList<Page>(toIndex - fromIndex);
        int i = fromIndex;
        while (i < toIndex) {
            pages.add(this.get(i++));
        }
        return pages;
    }

    @Override
    public boolean add(Page page) {
        return this.commonAddAll(-1, Arrays.asList(page));
    }

    @Override
    public boolean addAll(Collection<? extends Page> pages) {
        return this.commonAddAll(-1, pages);
    }

    @Override
    public void clear() {
        throw new NotImplementedException();
    }

    @Override
    public boolean contains(Object page) {
        throw new NotImplementedException();
    }

    @Override
    public boolean containsAll(Collection<?> pages) {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        throw new NotImplementedException();
    }

    @Override
    public boolean remove(Object page) {
        Page pageObj = (Page)page;
        PdfDictionary pageData = (PdfDictionary)pageObj.getBaseDataObject();
        PdfDirectObject parent = pageData.get(PdfName.Parent);
        PdfDictionary parentData = (PdfDictionary)File.resolve(parent);
        PdfDirectObject kids = parentData.get(PdfName.Kids);
        PdfArray kidsData = (PdfArray)File.resolve(kids);
        kidsData.remove(pageObj.getBaseObject());
        boolean updateParent = !File.update(kids);
        pageData.put(PdfName.Parent, null);
        pageObj.update();
        do {
            PdfDirectObject count = parentData.get(PdfName.Count);
            IPdfNumber countData = (IPdfNumber)((Object)File.resolve(count));
            countData.translateNumberValue(-1.0);
            if (updateParent |= !File.update(count)) {
                File.update(parent);
                updateParent = false;
            }
            parent = parentData.get(PdfName.Parent);
            parentData = (PdfDictionary)File.resolve(parent);
        } while (parent != null);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> pages) {
        boolean changed = false;
        for (Object page : pages) {
            changed |= this.remove(page);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> pages) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        return (Integer)((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Count)).getRawValue();
    }

    public Page[] toArray() {
        throw new NotImplementedException();
    }

    @Override
    public <T> T[] toArray(T[] pages) {
        throw new NotImplementedException();
    }

    @Override
    public Iterator<Page> iterator() {
        return new Iterator<Page>(){
            private int index = 0;
            private int size;
            private int levelIndex;
            private Stack<Integer> levelIndexes;
            private PdfDictionary parent;
            private PdfArray kids;
            {
                this.size = Pages.this.size();
                this.levelIndex = 0;
                this.levelIndexes = new Stack();
                this.parent = (PdfDictionary)Pages.this.getBaseDataObject();
                this.kids = (PdfArray)File.resolve(this.parent.get(PdfName.Kids));
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Page next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.getNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Page getNext() {
                while (true) {
                    if (this.kids.size() == this.levelIndex) {
                        this.levelIndex = this.levelIndexes.pop() + 1;
                        this.parent = (PdfDictionary)File.resolve(this.parent.get(PdfName.Parent));
                        this.kids = (PdfArray)File.resolve(this.parent.get(PdfName.Kids));
                        continue;
                    }
                    PdfReference kidReference = (PdfReference)this.kids.get(this.levelIndex);
                    PdfDictionary kid = (PdfDictionary)File.resolve(kidReference);
                    if (kid.get(PdfName.Type).equals(PdfName.Page)) {
                        ++this.index;
                        ++this.levelIndex;
                        return new Page(kidReference);
                    }
                    this.levelIndexes.push(this.levelIndex);
                    this.parent = kid;
                    this.kids = (PdfArray)File.resolve(this.parent.get(PdfName.Kids));
                    this.levelIndex = 0;
                }
            }
        };
    }

    private boolean commonAddAll(int index, Collection<? extends Page> pages) {
        int offset;
        PdfArray kidsData;
        PdfDirectObject kids;
        PdfDictionary parentData;
        PdfDirectObject parent;
        if (index == -1) {
            parent = this.getBaseObject();
            parentData = (PdfDictionary)this.getBaseDataObject();
            kids = parentData.get(PdfName.Kids);
            kidsData = (PdfArray)File.resolve(kids);
            offset = 0;
        } else {
            Page page = this.get(index);
            parent = ((PdfDictionary)page.getBaseDataObject()).get(PdfName.Parent);
            parentData = (PdfDictionary)File.resolve(parent);
            kids = parentData.get(PdfName.Kids);
            kidsData = (PdfArray)File.resolve(kids);
            offset = kidsData.indexOf(page.getBaseObject());
        }
        for (Page page : pages) {
            if (index == -1) {
                kidsData.add(page.getBaseObject());
            } else {
                kidsData.add(offset++, page.getBaseObject());
            }
            ((PdfDictionary)page.getBaseDataObject()).put(PdfName.Parent, parent);
            page.update();
        }
        boolean bl = !File.update(kids);
        do {
            PdfDirectObject count = parentData.get(PdfName.Count);
            IPdfNumber countData = (IPdfNumber)((Object)File.resolve(count));
            countData.translateNumberValue(pages.size());
            if ((n |= File.update(count) ? 0 : 1) != 0) {
                File.update(parent);
                int n = 0;
            }
            parent = parentData.get(PdfName.Parent);
            parentData = (PdfDictionary)File.resolve(parent);
        } while (parent != null);
        return true;
    }
}

