/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents;

import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.Dimension;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PageFormat {
    private static final String IsoSeriesSize_A = "A";
    private static final String IsoSeriesSize_B = "B";
    private static final String IsoSeriesSize_C = "C";
    private static final Pattern IsoSeriesSizePattern = Pattern.compile("([ABC])([\\d]+)");

    public static Dimension getSize() {
        return PageFormat.getSize(SizeEnum.A4);
    }

    public static Dimension getSize(SizeEnum size) {
        return PageFormat.getSize(size, OrientationEnum.Portrait);
    }

    public static Dimension getSize(SizeEnum size, OrientationEnum orientation) {
        int width;
        int height = 0;
        String sizeName = size.name();
        Matcher matcher = IsoSeriesSizePattern.matcher(sizeName);
        if (matcher.matches()) {
            int baseWidth;
            int baseHeight = 0;
            String isoSeriesSize = matcher.group(1);
            if (isoSeriesSize.equals(IsoSeriesSize_A)) {
                baseWidth = 2384;
                baseHeight = 3370;
            } else if (isoSeriesSize.equals(IsoSeriesSize_B)) {
                baseWidth = 2834;
                baseHeight = 4008;
            } else if (isoSeriesSize.equals(IsoSeriesSize_C)) {
                baseWidth = 2599;
                baseHeight = 3676;
            } else {
                throw new NotImplementedException("Paper format " + (Object)((Object)size) + " not supported yet.");
            }
            int isoSeriesSizeIndex = Integer.parseInt(matcher.group(2));
            double isoSeriesSizeFactor = 1.0 / Math.pow(2.0, (double)isoSeriesSizeIndex / 2.0);
            width = (int)Math.floor((double)baseWidth * isoSeriesSizeFactor);
            height = (int)Math.floor((double)baseHeight * isoSeriesSizeFactor);
        } else {
            switch (size) {
                case ArchA: {
                    width = 648;
                    height = 864;
                    break;
                }
                case ArchB: {
                    width = 864;
                    height = 1296;
                    break;
                }
                case ArchC: {
                    width = 1296;
                    height = 1728;
                    break;
                }
                case ArchD: {
                    width = 1728;
                    height = 2592;
                    break;
                }
                case ArchE: {
                    width = 2592;
                    height = 3456;
                    break;
                }
                case Letter: 
                case AnsiA: {
                    width = 612;
                    height = 792;
                    break;
                }
                case Tabloid: 
                case AnsiB: {
                    width = 792;
                    height = 1224;
                    break;
                }
                case AnsiC: {
                    width = 1224;
                    height = 1584;
                    break;
                }
                case AnsiD: {
                    width = 1584;
                    height = 2448;
                    break;
                }
                case AnsiE: {
                    width = 2448;
                    height = 3168;
                    break;
                }
                case Legal: {
                    width = 612;
                    height = 1008;
                    break;
                }
                case Executive: {
                    width = 522;
                    height = 756;
                    break;
                }
                case Statement: {
                    width = 396;
                    height = 612;
                    break;
                }
                default: {
                    throw new NotImplementedException("Paper format " + (Object)((Object)size) + " not supported yet.");
                }
            }
        }
        switch (orientation) {
            case Portrait: {
                return new Dimension(width, height);
            }
            case Landscape: {
                return new Dimension(height, width);
            }
        }
        throw new NotImplementedException("Orientation " + (Object)((Object)orientation) + " not supported yet.");
    }

    private PageFormat() {
    }

    public static enum OrientationEnum {
        Portrait,
        Landscape;

    }

    public static enum SizeEnum {
        A0,
        A1,
        A2,
        A3,
        A4,
        A5,
        A6,
        A7,
        A8,
        A9,
        A10,
        B0,
        B1,
        B2,
        B3,
        B4,
        B5,
        B6,
        B7,
        B8,
        B9,
        B10,
        C0,
        C1,
        C2,
        C3,
        C4,
        C5,
        C6,
        C7,
        C8,
        C9,
        C10,
        Letter,
        Legal,
        Executive,
        Statement,
        Tabloid,
        ArchA,
        ArchB,
        ArchC,
        ArchD,
        ArchE,
        AnsiA,
        AnsiB,
        AnsiC,
        AnsiD,
        AnsiE;

    }
}

