/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents;

import it.stefanochizzolini.clown.bytes.IBuffer;
import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.PageActions;
import it.stefanochizzolini.clown.documents.PageAnnotations;
import it.stefanochizzolini.clown.documents.contents.Contents;
import it.stefanochizzolini.clown.documents.contents.IContentContext;
import it.stefanochizzolini.clown.documents.contents.Resources;
import it.stefanochizzolini.clown.documents.contents.composition.PrimitiveFilter;
import it.stefanochizzolini.clown.documents.contents.objects.ContentObject;
import it.stefanochizzolini.clown.documents.contents.xObjects.FormXObject;
import it.stefanochizzolini.clown.documents.contents.xObjects.XObject;
import it.stefanochizzolini.clown.documents.interaction.navigation.page.Transition;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfStream;
import it.stefanochizzolini.clown.objects.Rectangle;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public class Page
extends PdfObjectWrapper<PdfDictionary>
implements IContentContext {
    public static Page wrap(PdfReference reference) {
        return new Page(reference);
    }

    public Page(Document context) {
        super(context.getFile(), new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.Contents}, new PdfDirectObject[]{PdfName.Page, context.getFile().register(new PdfStream())}));
    }

    public Page(Document context, Dimension2D size, Resources resources) {
        super(context.getFile(), new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.MediaBox, PdfName.Contents, PdfName.Resources}, new PdfDirectObject[]{PdfName.Page, (PdfDirectObject)new Rectangle(0.0, 0.0, size.getWidth(), size.getHeight()).getBaseDataObject(), context.getFile().register(new PdfStream()), resources.getBaseObject()}));
    }

    public Page(PdfDirectObject baseObject) {
        super(baseObject, null);
    }

    @Override
    public Page clone(Document context) {
        File contextFile = context.getFile();
        PdfDictionary clone = new PdfDictionary(((PdfDictionary)this.getBaseDataObject()).size());
        for (Map.Entry<PdfName, PdfDirectObject> entry : ((PdfDictionary)this.getBaseDataObject()).entrySet()) {
            PdfName key = entry.getKey();
            if (key.equals(PdfName.Parent) || key.equals(PdfName.Annots)) continue;
            clone.put(key, (PdfDirectObject)entry.getValue().clone(contextFile));
        }
        return new Page(contextFile.getIndirectObjects().add(clone).getReference());
    }

    public PageActions getActions() {
        PdfDirectObject actionsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA);
        if (actionsObject == null) {
            return null;
        }
        return new PageActions(actionsObject, this.getContainer());
    }

    public PageAnnotations getAnnotations() {
        PdfDirectObject annotationsObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Annots);
        if (annotationsObject == null) {
            return null;
        }
        return new PageAnnotations(annotationsObject, this.getContainer(), this);
    }

    public double getDuration() {
        IPdfNumber durationObject = (IPdfNumber)((Object)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Dur));
        if (durationObject == null) {
            return 0.0;
        }
        return durationObject.getNumberValue();
    }

    public int getIndex() {
        PdfReference ancestorKidReference = (PdfReference)this.getBaseObject();
        PdfReference parentReference = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Parent);
        PdfDictionary parent = (PdfDictionary)File.resolve(parentReference);
        PdfArray kids = (PdfArray)File.resolve(parent.get(PdfName.Kids));
        int index = 0;
        int i = 0;
        while (true) {
            PdfReference kidReference;
            if ((kidReference = (PdfReference)kids.get(i)).equals(ancestorKidReference)) {
                if (!parent.containsKey(PdfName.Parent)) {
                    return index;
                }
                ancestorKidReference = parentReference;
                parentReference = (PdfReference)parent.get(PdfName.Parent);
                parent = (PdfDictionary)File.resolve(parentReference);
                kids = (PdfArray)File.resolve(parent.get(PdfName.Kids));
                i = -1;
            } else {
                PdfDictionary kid = (PdfDictionary)File.resolve(kidReference);
                index = kid.get(PdfName.Type).equals(PdfName.Page) ? ++index : (index += ((Integer)((PdfInteger)kid.get(PdfName.Count)).getRawValue()).intValue());
            }
            ++i;
        }
    }

    public Dimension2D getSize() {
        PdfArray box = (PdfArray)File.resolve(this.getInheritableAttribute(PdfName.MediaBox));
        if (box == null) {
            return null;
        }
        return new Dimension((int)((IPdfNumber)((Object)box.get(2))).getNumberValue(), (int)((IPdfNumber)((Object)box.get(3))).getNumberValue());
    }

    public TabOrderEnum getTabOrder() {
        return TabOrderEnum.get((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Tabs));
    }

    public Transition getTransition() {
        PdfDirectObject transitionObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Trans);
        if (transitionObject == null) {
            return null;
        }
        return new Transition(transitionObject, this.getContainer());
    }

    public void setActions(PageActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AA, value.getBaseObject());
    }

    public void setAnnotations(PageAnnotations value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Annots, value.getBaseObject());
    }

    public void setDuration(double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Dur, new PdfReal(value));
    }

    public void setSize(Dimension2D value) {
        PdfDictionary dictionary = (PdfDictionary)this.getBaseDataObject();
        PdfDirectObject entry = dictionary.get(PdfName.MediaBox);
        if (entry == null) {
            entry = (PdfDirectObject)this.getInheritableAttribute(PdfName.MediaBox).clone(this.getFile());
            dictionary.put(PdfName.MediaBox, entry);
        }
        PdfArray box = (PdfArray)File.resolve(entry);
        ((IPdfNumber)((Object)box.get(2))).setNumberValue(value.getWidth());
        ((IPdfNumber)((Object)box.get(3))).setNumberValue(value.getHeight());
    }

    public void setTabOrder(TabOrderEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Tabs, value.getCode());
    }

    public void setTransition(Transition value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Trans, value.getBaseObject());
    }

    @Override
    public Rectangle2D getBox() {
        PdfArray box = (PdfArray)File.resolve(this.getInheritableAttribute(PdfName.MediaBox));
        return new Rectangle2D.Double(((IPdfNumber)((Object)box.get(0))).getNumberValue(), ((IPdfNumber)((Object)box.get(1))).getNumberValue(), ((IPdfNumber)((Object)box.get(2))).getNumberValue(), ((IPdfNumber)((Object)box.get(3))).getNumberValue());
    }

    @Override
    public Contents getContents() {
        return new Contents(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Contents), ((PdfReference)this.getBaseObject()).getIndirectObject(), this);
    }

    @Override
    public Resources getResources() {
        return new Resources(this.getInheritableAttribute(PdfName.Resources), ((PdfReference)this.getBaseObject()).getIndirectObject());
    }

    @Override
    public ContentObject toInlineObject(PrimitiveFilter context) {
        throw new NotImplementedException();
    }

    @Override
    public XObject toXObject(Document context) {
        File contextFile = context.getFile();
        FormXObject form = new FormXObject(context);
        PdfStream formStream = (PdfStream)form.getBaseDataObject();
        PdfDictionary formHeader = formStream.getHeader();
        formHeader.put(PdfName.BBox, (PdfDirectObject)this.getInheritableAttribute(PdfName.MediaBox).clone(contextFile));
        PdfDirectObject resourcesObject = this.getInheritableAttribute(PdfName.Resources);
        formHeader.put(PdfName.Resources, context.equals(this.getDocument()) ? resourcesObject : (PdfDirectObject)resourcesObject.clone(contextFile));
        IBuffer formBody = formStream.getBody();
        PdfDataObject contentsDataObject = File.resolve(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Contents));
        if (contentsDataObject instanceof PdfStream) {
            formBody.append(((PdfStream)contentsDataObject).getBody());
        } else {
            for (PdfDirectObject contentStreamObject : (PdfArray)contentsDataObject) {
                formBody.append(((PdfStream)File.resolve(contentStreamObject)).getBody());
            }
        }
        return form;
    }

    protected PdfDirectObject getInheritableAttribute(PdfName key) {
        PdfDictionary dictionary = (PdfDictionary)this.getBaseDataObject();
        do {
            PdfDirectObject entry;
            if ((entry = dictionary.get(key)) == null) continue;
            return entry;
        } while ((dictionary = (PdfDictionary)File.resolve(dictionary.get(PdfName.Parent))) != null);
        if (((PdfDictionary)this.getBaseDataObject()).get(PdfName.Parent) == null) {
            throw new RuntimeException("Inheritable attributes unreachable: Page objects MUST be inserted into their document's Pages collection before being used.");
        }
        return null;
    }

    public static enum TabOrderEnum {
        Row(PdfName.R),
        Column(PdfName.C),
        Structure(PdfName.S);

        private final PdfName code;

        public static TabOrderEnum get(PdfName value) {
            TabOrderEnum[] tabOrderEnumArray = TabOrderEnum.values();
            int n = tabOrderEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TabOrderEnum tabOrder = tabOrderEnumArray[n2];
                if (tabOrder.getCode().equals(value)) {
                    return tabOrder;
                }
                ++n2;
            }
            return null;
        }

        private TabOrderEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

