/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.Destination;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.LocalDestination;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.util.NotImplementedException;

public class DocumentActions
extends PdfObjectWrapper<PdfDictionary> {
    public DocumentActions(Document context) {
        super(context.getFile(), new PdfDictionary());
    }

    public DocumentActions(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public DocumentActions clone(Document context) {
        throw new NotImplementedException();
    }

    public Action getAfterPrint() {
        PdfDirectObject afterPrintObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.DP);
        if (afterPrintObject == null) {
            return null;
        }
        return Action.wrap(afterPrintObject, this.getContainer());
    }

    public Action getAfterSave() {
        PdfDirectObject afterSaveObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.DS);
        if (afterSaveObject == null) {
            return null;
        }
        return Action.wrap(afterSaveObject, this.getContainer());
    }

    public Action getBeforePrint() {
        PdfDirectObject beforePrintObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.WP);
        if (beforePrintObject == null) {
            return null;
        }
        return Action.wrap(beforePrintObject, this.getContainer());
    }

    public Action getBeforeSave() {
        PdfDirectObject beforeSaveObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.WS);
        if (beforeSaveObject == null) {
            return null;
        }
        return Action.wrap(beforeSaveObject, this.getContainer());
    }

    public Action getOnClose() {
        PdfDirectObject onCloseObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.DC);
        if (onCloseObject == null) {
            return null;
        }
        return Action.wrap(onCloseObject, this.getContainer());
    }

    public PdfObjectWrapper<?> getOnOpen() {
        PdfDirectObject onOpenObject = ((PdfDictionary)this.getDocument().getBaseDataObject()).get(PdfName.OpenAction);
        if (onOpenObject == null) {
            return null;
        }
        if (onOpenObject instanceof PdfDictionary) {
            return Action.wrap(onOpenObject, this.getContainer());
        }
        return Destination.wrap(onOpenObject, this.getContainer(), null);
    }

    public void setAfterPrint(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.DP, value.getBaseObject());
    }

    public void setAfterSave(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.DS, value.getBaseObject());
    }

    public void setBeforePrint(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.WP, value.getBaseObject());
    }

    public void setBeforeSave(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.WS, value.getBaseObject());
    }

    public void setOnClose(Action value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.DC, value.getBaseObject());
    }

    public void setOnOpen(PdfObjectWrapper<?> value) {
        if (!(value instanceof Action) && !(value instanceof LocalDestination)) {
            throw new IllegalArgumentException("Value MUST be either an Action or a LocalDestination.");
        }
        Document document = this.getDocument();
        ((PdfDictionary)document.getBaseDataObject()).put(PdfName.OpenAction, value.getBaseObject());
        document.update();
    }
}

