/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.bytes;

import it.stefanochizzolini.clown.bytes.IBuffer;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.bytes.filters.Filter;
import it.stefanochizzolini.clown.util.ConvertUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public final class Buffer
implements IBuffer {
    private static final int DefaultCapacity = 256;
    private static final String Encoding = "ISO-8859-1";
    private byte[] data;
    private int length;
    private int position = 0;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public Buffer() {
        this(0);
    }

    public Buffer(int capacity) {
        if (capacity < 1) {
            capacity = 256;
        }
        this.data = new byte[capacity];
        this.length = 0;
    }

    public Buffer(BufferedReader dataStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int bufferLength;
            char[] buffer = new char[8192];
            while ((bufferLength = dataStream.read(buffer, 0, buffer.length)) != -1) {
                int i = 0;
                while (i < bufferLength) {
                    outputStream.write((byte)buffer[i]);
                    ++i;
                }
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.data = outputStream.toByteArray();
        this.length = this.data.length;
    }

    public Buffer(InputStream dataStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int bufferLength;
            byte[] buffer = new byte[8192];
            while ((bufferLength = dataStream.read(buffer, 0, buffer.length)) != -1) {
                outputStream.write(buffer, 0, bufferLength);
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.data = outputStream.toByteArray();
        this.length = this.data.length;
    }

    public Buffer(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    public Buffer(byte[] data, ByteOrder byteOrder) {
        this.data = data;
        this.length = data.length;
        this.byteOrder = byteOrder;
    }

    @Override
    public void append(byte data) {
        while (true) {
            try {
                this.data[this.length] = data;
            }
            catch (Exception e) {
                if (this.ensureCapacity(1)) continue;
                throw new RuntimeException(e);
            }
            break;
        }
        ++this.length;
    }

    @Override
    public void append(byte[] data) {
        this.append(data, 0, data.length);
    }

    @Override
    public void append(byte[] data, int offset, int length) {
        while (true) {
            try {
                System.arraycopy(data, offset, this.data, this.length, length);
            }
            catch (Exception e) {
                if (this.ensureCapacity(length)) continue;
                throw new RuntimeException(e);
            }
            break;
        }
        this.length += length;
    }

    @Override
    public void append(String data) {
        try {
            this.append(data.getBytes(Encoding));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void append(IInputStream data) {
        this.append(data.toByteArray(), 0, (int)data.getLength());
    }

    @Override
    public Buffer clone() {
        Buffer clone = new Buffer(this.getCapacity());
        clone.append(this.data);
        return clone;
    }

    @Override
    public void decode(Filter filter) {
        this.data = filter.decode(this.data, 0, this.length);
        this.length = this.data.length;
    }

    @Override
    public void delete(int index, int length) {
        try {
            System.arraycopy(this.data, index + length, this.data, index, this.length - (index + length));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.length -= length;
    }

    @Override
    public byte[] encode(Filter filter) {
        return filter.encode(this.data, 0, this.length);
    }

    @Override
    public int getByte(int index) {
        return this.data[index];
    }

    @Override
    public byte[] getByteArray(int index, int length) {
        byte[] data = new byte[length];
        System.arraycopy(this.data, index, data, 0, length);
        return data;
    }

    @Override
    public String getString(int index, int length) {
        try {
            return new String(this.data, index, length, Encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getCapacity() {
        return this.data.length;
    }

    @Override
    public void insert(int index, byte[] data) {
        this.insert(index, data, 0, data.length);
    }

    @Override
    public void insert(int index, byte[] data, int offset, int length) {
        while (true) {
            try {
                System.arraycopy(this.data, index, this.data, index + length, this.length - index);
            }
            catch (Exception e) {
                if (this.ensureCapacity(length)) continue;
                throw new RuntimeException(e);
            }
            break;
        }
        System.arraycopy(data, offset, this.data, index, length);
        this.length += length;
    }

    @Override
    public void insert(int index, String data) {
        try {
            this.insert(index, data.getBytes(Encoding));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void insert(int index, IInputStream data) {
        this.insert(index, data.toByteArray());
    }

    @Override
    public void replace(int index, byte[] data) {
        System.arraycopy(data, 0, this.data, index, data.length);
    }

    @Override
    public void replace(int index, byte[] data, int offset, int length) {
        System.arraycopy(data, offset, this.data, index, data.length);
    }

    @Override
    public void replace(int index, String data) {
        try {
            this.replace(index, data.getBytes(Encoding));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void replace(int index, IInputStream data) {
        this.replace(index, data.toByteArray());
    }

    @Override
    public void setLength(int value) {
        this.length = value;
    }

    @Override
    public void writeTo(IOutputStream stream) {
        stream.write(this.data, 0, this.length);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void read(byte[] data) {
        this.read(data, 0, data.length);
    }

    @Override
    public void read(byte[] data, int offset, int length) {
        try {
            System.arraycopy(this.data, this.position, data, offset, length);
            this.position += length;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readByte() throws EOFException {
        try {
            return this.data[this.position++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EOFException();
        }
    }

    @Override
    public int readInt() throws EOFException {
        int value = ConvertUtils.byteArrayToInt(this.data, this.position, this.byteOrder);
        this.position += 4;
        return value;
    }

    @Override
    public String readLine() throws EOFException {
        StringBuilder buffer = new StringBuilder();
        try {
            byte c;
            while ((c = this.data[this.position++]) != 13 && c != 10) {
                buffer.append((char)c);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EOFException();
        }
        return buffer.toString();
    }

    @Override
    public short readShort() throws EOFException {
        short value = (short)ConvertUtils.byteArrayToNumber(this.data, this.position, 2, this.byteOrder);
        this.position += 2;
        return value;
    }

    @Override
    public String readString(int length) {
        try {
            String data = new String(this.data, this.position, length, Encoding);
            this.position += length;
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        try {
            return this.data[this.position++] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedShort() throws EOFException {
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8;
            }
            return (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EOFException();
        }
    }

    @Override
    public void seek(long position) {
        this.position = (int)position;
    }

    @Override
    public void setByteOrder(ByteOrder value) {
        this.byteOrder = value;
    }

    @Override
    public void setPosition(long value) {
        this.position = (int)value;
    }

    @Override
    public void skip(long offset) {
        this.position += (int)offset;
    }

    @Override
    public byte[] toByteArray() {
        byte[] data = new byte[this.length];
        System.arraycopy(this.data, 0, data, 0, this.length);
        return data;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void write(byte[] data) {
        this.append(data);
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        this.append(data, offset, length);
    }

    @Override
    public void write(String data) {
        this.append(data);
    }

    @Override
    public void write(IInputStream data) {
        this.append(data);
    }

    protected boolean ensureCapacity(int additionalLength) {
        int minCapacity = this.length + additionalLength;
        if (minCapacity <= this.data.length) {
            return false;
        }
        byte[] data = new byte[Math.max(this.data.length << 1, minCapacity)];
        System.arraycopy(this.data, 0, data, 0, this.length);
        this.data = data;
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

