/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.util;

import java.nio.ByteOrder;

public class ConvertUtils {
    private static final char[] HexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String byteArrayToHex(byte[] data) {
        int dataLength = data.length;
        char[] out = new char[dataLength * 2];
        int dataIndex = 0;
        int outIndex = 0;
        while (dataIndex < dataLength) {
            out[outIndex++] = HexDigits[(0xF0 & data[dataIndex]) >>> 4];
            out[outIndex++] = HexDigits[0xF & data[dataIndex]];
            ++dataIndex;
        }
        return new String(out);
    }

    public static int byteArrayToInt(byte[] data) {
        return ConvertUtils.byteArrayToInt(data, 0, ByteOrder.BIG_ENDIAN);
    }

    public static int byteArrayToInt(byte[] data, int index, ByteOrder byteOrder) {
        return ConvertUtils.byteArrayToNumber(data, index, 4, byteOrder);
    }

    public static int byteArrayToNumber(byte[] data, int index, int length, ByteOrder byteOrder) {
        int value = 0;
        length = Math.min(length, data.length - index);
        int i = index;
        int endIndex = index + length;
        while (i < endIndex) {
            value |= (data[i] & 0xFF) << 8 * (byteOrder == ByteOrder.LITTLE_ENDIAN ? i - index : endIndex - i - 1);
            ++i;
        }
        return value;
    }

    public static byte[] hexToByteArray(String data) {
        char[] dataChars = data.toCharArray();
        int dataLength = dataChars.length;
        if (dataLength % 2 != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[dataLength / 2];
        int outIndex = 0;
        int dataIndex = 0;
        while (dataIndex < dataLength) {
            out[outIndex] = (byte)((ConvertUtils.toHexDigit(dataChars[dataIndex++]) << 4 | ConvertUtils.toHexDigit(dataChars[dataIndex++])) & 0xFF);
            ++outIndex;
        }
        return out;
    }

    public static byte[] intToByteArray(int data) {
        return new byte[]{(byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
    }

    private static int toHexDigit(char dataChar) {
        int digit = Character.digit(dataChar, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + dataChar);
        }
        return digit;
    }
}

