/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.tools;

import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.contents.ContentScanner;
import it.stefanochizzolini.clown.documents.contents.Contents;
import it.stefanochizzolini.clown.documents.contents.composition.PrimitiveFilter;
import it.stefanochizzolini.clown.documents.contents.objects.RestoreGraphicsState;
import it.stefanochizzolini.clown.documents.contents.objects.SaveGraphicsState;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfStream;

public class PageStamper {
    private Page page;
    private PrimitiveFilter background;
    private PrimitiveFilter foreground;

    public PageStamper() {
        this(null);
    }

    public PageStamper(Page page) {
        this.setPage(page);
    }

    public void flush() {
        PdfArray streams;
        PdfDirectObject contentsObject = ((PdfDictionary)this.page.getBaseDataObject()).get(PdfName.Contents);
        PdfDataObject contentsDataObject = File.resolve(contentsObject);
        if (contentsDataObject instanceof PdfStream) {
            streams = new PdfArray();
            streams.add(contentsObject);
            ((PdfDictionary)this.page.getBaseDataObject()).put(PdfName.Contents, streams);
            this.page.update();
        } else {
            streams = (PdfArray)contentsDataObject;
            if (!File.update(contentsObject)) {
                this.page.update();
            }
        }
        this.background.flush();
        streams.add(0, (PdfReference)this.background.getScanner().getContents().getBaseObject());
        this.foreground.flush();
        streams.add((PdfReference)this.foreground.getScanner().getContents().getBaseObject());
    }

    public PrimitiveFilter getBackground() {
        return this.background;
    }

    public PrimitiveFilter getForeground() {
        return this.foreground;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page value) {
        this.page = value;
        if (this.page == null) {
            this.background = null;
            this.foreground = null;
        } else {
            this.background = this.createFilter();
            this.background.add(SaveGraphicsState.Value);
            this.background.add(RestoreGraphicsState.Value);
            this.background.add(SaveGraphicsState.Value);
            this.background.getScanner().move(1);
            this.foreground = this.createFilter();
            this.foreground.add(RestoreGraphicsState.Value);
        }
    }

    private PrimitiveFilter createFilter() {
        PdfReference reference = this.page.getFile().register(new PdfStream());
        return new PrimitiveFilter(new ContentScanner(new Contents(reference, reference.getIndirectObject(), this.page)));
    }
}

