/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.tools;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.Page;
import it.stefanochizzolini.clown.documents.Pages;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PageManager {
    private Document document;
    private Pages pages;

    public PageManager() {
        this(null);
    }

    public PageManager(Document document) {
        this.setDocument(document);
    }

    public void add(Document document) {
        this.add(document.getPages());
    }

    public void add(Collection<Page> pages) {
        this.pages.addAll((Collection<? extends Page>)this.document.contextualize(pages));
        this.pages.update();
    }

    public void add(int index, Document document) {
        this.add(index, document.getPages());
    }

    public void add(int index, Collection<Page> pages) {
        Collection<? extends PdfObjectWrapper<?>> addingPages = this.document.contextualize(pages);
        if (index >= this.pages.size()) {
            this.pages.addAll((Collection<? extends Page>)addingPages);
        } else {
            this.pages.addAll(index, (Collection<? extends Page>)addingPages);
        }
        this.pages.update();
    }

    public Document extract(int beginIndex, int endIndex) {
        Document extractedDocument = new File().getDocument();
        extractedDocument.getPages().addAll((Collection<? extends Page>)extractedDocument.contextualize(this.pages.subList(beginIndex, endIndex)));
        return extractedDocument;
    }

    public void move(int beginIndex, int endIndex, int targetIndex) {
        int pageCount = this.pages.size();
        List<Page> movingPages = this.pages.subList(beginIndex, endIndex);
        this.pages.removeAll(movingPages);
        pageCount -= movingPages.size();
        if (targetIndex > beginIndex) {
            targetIndex -= movingPages.size();
        }
        if (targetIndex >= pageCount) {
            this.pages.addAll((Collection<? extends Page>)movingPages);
        } else {
            this.pages.addAll(targetIndex, (Collection<? extends Page>)movingPages);
        }
        this.pages.update();
    }

    public Document getDocument() {
        return this.document;
    }

    public void remove(int beginIndex, int endIndex) {
        List<Page> removingPages = this.pages.subList(beginIndex, endIndex);
        this.pages.removeAll(removingPages);
        this.pages.update();
        this.document.decontextualize(removingPages);
    }

    public void setDocument(Document value) {
        this.document = value;
        this.pages = this.document.getPages();
    }

    public List<Document> split() {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Page page : this.pages) {
            Document pageDocument = new File().getDocument();
            pageDocument.getPages().add(page.clone(pageDocument));
            documents.add(pageDocument);
        }
        return documents;
    }
}

