/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.tokens;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.files.IndirectObjects;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.tokens.Parser;
import java.util.Map;

public class Writer {
    private static final byte[] HeaderBinaryHint = new byte[]{37, -128, -128, -128, -128, 13};
    private File file;
    private IOutputStream stream;

    public Writer(IOutputStream stream, File file) {
        this.stream = stream;
        this.file = file;
    }

    public IOutputStream getStream() {
        return this.stream;
    }

    public void writeStandard() {
        StringBuilder xrefBuilder = new StringBuilder();
        int xrefSize = this.file.getIndirectObjects().size();
        this.stream.write("%PDF-" + this.file.getDocument().getVersion() + "\r");
        this.stream.write(HeaderBinaryHint);
        StringBuilder xrefInUseBlockBuilder = new StringBuilder();
        IndirectObjects indirectObjects = this.file.getIndirectObjects();
        PdfReference freeReference = indirectObjects.get(0).getReference();
        int index = 1;
        while (index < xrefSize) {
            PdfIndirectObject indirectObject = indirectObjects.get(index);
            if (indirectObject.isInUse()) {
                xrefInUseBlockBuilder.append(indirectObject.getReference().getCrossReference(this.stream.getLength()));
                indirectObject.writeTo(this.stream);
            } else {
                xrefBuilder.append(String.valueOf(freeReference.getCrossReference(index)) + xrefInUseBlockBuilder.toString());
                xrefInUseBlockBuilder.setLength(0);
                freeReference = indirectObject.getReference();
            }
            ++index;
        }
        xrefBuilder.append(String.valueOf(freeReference.getCrossReference(0L)) + xrefInUseBlockBuilder.toString());
        long startxref = this.stream.getLength();
        this.stream.write("xref\r0 " + xrefSize + "\r");
        this.stream.write(xrefBuilder.toString());
        this.stream.write("trailer\r");
        PdfDictionary trailer = this.file.getTrailer();
        trailer.put(PdfName.Size, new PdfInteger(xrefSize));
        trailer.remove(PdfName.Prev);
        trailer.writeTo(this.stream);
        this.stream.write("\rstartxref\r" + startxref + "\r" + "%%EOF");
    }

    public void writeIncremental() {
        StringBuilder xrefBuilder = new StringBuilder();
        int xrefSize = this.file.getIndirectObjects().size();
        Parser parser = this.file.getReader().getParser();
        this.stream.write(parser.getStream());
        StringBuilder xrefSubBuilder = new StringBuilder();
        int xrefSubCount = 0;
        int prevKey = 0;
        for (Map.Entry<Integer, PdfIndirectObject> indirectObjectEntry : this.file.getIndirectObjects().getModifiedObjects().entrySet()) {
            if (indirectObjectEntry.getKey() - prevKey == 1 || prevKey == 0) {
                ++xrefSubCount;
            } else {
                xrefBuilder.append(String.valueOf(prevKey - xrefSubCount + 1) + " " + xrefSubCount + "\r" + xrefSubBuilder.toString());
                xrefSubBuilder.setLength(0);
                xrefSubCount = 1;
            }
            prevKey = indirectObjectEntry.getKey();
            if (indirectObjectEntry.getValue().isInUse()) {
                xrefSubBuilder.append(indirectObjectEntry.getValue().getReference().getCrossReference(this.stream.getLength()));
                indirectObjectEntry.getValue().writeTo(this.stream);
                continue;
            }
            xrefSubBuilder.append(indirectObjectEntry.getValue().getReference().getCrossReference(0L));
        }
        xrefBuilder.append(String.valueOf(prevKey - xrefSubCount + 1) + " " + xrefSubCount + "\r" + xrefSubBuilder.toString());
        long startxref = this.stream.getLength();
        this.stream.write("xref\r");
        this.stream.write(xrefBuilder.toString());
        try {
            this.stream.write("trailer\r");
            PdfDictionary trailer = this.file.getTrailer();
            trailer.put(PdfName.Size, new PdfInteger(xrefSize));
            trailer.put(PdfName.Prev, new PdfInteger((int)parser.retrieveXRefOffset()));
            trailer.writeTo(this.stream);
            this.stream.write("\rstartxref\r" + startxref + "\r" + "%%EOF");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

