/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.tokens;

import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.tokens.FileFormatException;
import it.stefanochizzolini.clown.tokens.Parser;
import it.stefanochizzolini.clown.tokens.TokenTypeEnum;
import it.stefanochizzolini.clown.tokens.XRefEntry;
import java.io.Closeable;
import java.io.IOException;

public class Reader
implements Closeable {
    private Parser parser;

    public Reader(IInputStream stream, File file) {
        this.parser = new Parser(stream, file);
    }

    public int hashCode() {
        return this.parser.hashCode();
    }

    public Parser getParser() {
        return this.parser;
    }

    public PdfDictionary readTrailer() throws FileFormatException {
        long xrefOffset = this.parser.retrieveXRefOffset();
        this.parser.seek(xrefOffset);
        this.parser.moveNext();
        if (!this.parser.getToken().equals("xref")) {
            throw new FileFormatException("'xref' keyword not found.", this.parser.getPosition());
        }
        while (true) {
            this.parser.moveNext();
            if (this.parser.getTokenType() == TokenTypeEnum.Keyword) break;
            this.parser.moveNext();
            int count = (Integer)this.parser.getToken();
            this.parser.skip(count * 20);
        }
        if (!this.parser.getToken().equals("trailer")) {
            throw new FileFormatException("'trailer' keyword not found.", this.parser.getPosition());
        }
        this.parser.moveNext();
        return (PdfDictionary)this.parser.parsePdfObject();
    }

    public XRefEntry[] readXRefTable(PdfDictionary trailer) throws FileFormatException {
        PdfInteger prevXRefOffset;
        PdfInteger xrefTableSize = (PdfInteger)trailer.get(PdfName.Size);
        XRefEntry[] xrefEntries = new XRefEntry[((Integer)xrefTableSize.getRawValue()).intValue()];
        this.parser.seek(this.parser.retrieveXRefOffset());
        this.readXRefSection(xrefEntries);
        while ((prevXRefOffset = (PdfInteger)trailer.get(PdfName.Prev)) != null) {
            this.parser.seek(((Integer)prevXRefOffset.getRawValue()).intValue());
            this.readXRefSection(xrefEntries);
            this.parser.moveNext();
            trailer = (PdfDictionary)this.parser.parsePdfObject();
        }
        return xrefEntries;
    }

    public String readVersion() throws FileFormatException {
        return this.parser.retrieveVersion();
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
            this.parser = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    protected void readXRefSection(XRefEntry[] xrefEntries) throws FileFormatException {
        this.parser.moveNext();
        if (!((String)this.parser.getToken()).equals("xref")) {
            throw new FileFormatException("'xref' keyword not found.", this.parser.getPosition());
        }
        block0: while (true) {
            this.parser.moveNext();
            if (this.parser.getTokenType() == TokenTypeEnum.Keyword && ((String)this.parser.getToken()).equals("trailer")) break;
            if (this.parser.getTokenType() != TokenTypeEnum.Integer) {
                throw new FileFormatException("Neither object number of the first object in this xref subsection nor end of xref section found.", this.parser.getPosition());
            }
            int startObjectNumber = (Integer)this.parser.getToken();
            this.parser.moveNext();
            if (this.parser.getTokenType() != TokenTypeEnum.Integer) {
                throw new FileFormatException("Number of entries in this xref subsection not found.", this.parser.getPosition());
            }
            int endObjectNumber = (Integer)this.parser.getToken() + startObjectNumber;
            int index = startObjectNumber;
            while (true) {
                if (index >= endObjectNumber) continue block0;
                if (xrefEntries[index] == null) {
                    XRefEntry.UsageEnum usage;
                    this.parser.moveNext();
                    int offset = (Integer)this.parser.getToken();
                    this.parser.moveNext();
                    int generation = (Integer)this.parser.getToken();
                    this.parser.moveNext();
                    String usageToken = (String)this.parser.getToken();
                    if (usageToken.equals("n")) {
                        usage = XRefEntry.UsageEnum.InUse;
                    } else if (usageToken.equals("f")) {
                        usage = XRefEntry.UsageEnum.Free;
                    } else {
                        throw new FileFormatException("Invalid xref entry.", this.parser.getPosition());
                    }
                    xrefEntries[index] = new XRefEntry(index, generation, offset, usage);
                } else {
                    this.parser.moveNext(3);
                }
                ++index;
            }
            break;
        }
    }
}

