/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.tokens;

import it.stefanochizzolini.clown.bytes.Buffer;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfBoolean;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDate;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfStream;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.tokens.FileFormatException;
import it.stefanochizzolini.clown.tokens.TokenTypeEnum;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Date;

public class Parser
implements Closeable {
    private static final String PdfHeader = "%PDF-";
    private File file;
    private IInputStream stream;
    private Object token;
    private TokenTypeEnum tokenType;
    private boolean multipleTokenParsing;

    protected static boolean isDelimiter(int c) {
        return c == 40 || c == 41 || c == 60 || c == 62 || c == 91 || c == 93 || c == 47 || c == 37;
    }

    protected static boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    protected static boolean isWhitespace(int c) {
        return c == 32 || Parser.isEOL(c) || c == 0 || c == 9 || c == 12;
    }

    Parser(IInputStream stream, File file) {
        this.stream = stream;
        this.file = file;
    }

    public long getLength() {
        return this.stream.getLength();
    }

    public long getPosition() {
        return this.stream.getPosition();
    }

    public IInputStream getStream() {
        return this.stream;
    }

    public Object getToken() {
        return this.token;
    }

    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    public boolean moveNext(int offset) throws FileFormatException {
        int index = 0;
        while (index < offset) {
            if (!this.moveNext()) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean moveNext() throws FileFormatException {
        StringBuilder buffer = null;
        this.token = null;
        int c = 0;
        try {
            while (Parser.isWhitespace(c = this.stream.readUnsignedByte())) {
            }
        }
        catch (EOFException e) {
            return false;
        }
        block9 : switch (c) {
            case 47: {
                this.tokenType = TokenTypeEnum.Name;
                buffer = new StringBuilder();
                try {
                    while (!Parser.isDelimiter(c = this.stream.readUnsignedByte()) && !Parser.isWhitespace(c)) {
                        buffer.append((char)c);
                    }
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed name object).", e, this.stream.getPosition());
                }
                this.stream.skip(-1L);
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                switch (c) {
                    case 46: {
                        this.tokenType = TokenTypeEnum.Real;
                        break;
                    }
                    case 43: 
                    case 45: {
                        this.tokenType = TokenTypeEnum.Integer;
                        break;
                    }
                    default: {
                        if (this.multipleTokenParsing) {
                            this.tokenType = TokenTypeEnum.Integer;
                            break;
                        }
                        this.multipleTokenParsing = true;
                        this.stream.skip(-1L);
                        this.moveNext();
                        if (this.tokenType != TokenTypeEnum.Integer) {
                            this.multipleTokenParsing = false;
                            return true;
                        }
                        int objectNumber = (Integer)this.token;
                        long oldOffset = this.stream.getPosition();
                        this.moveNext();
                        if (this.tokenType != TokenTypeEnum.Integer) {
                            this.stream.seek(oldOffset);
                            this.token = objectNumber;
                            this.tokenType = TokenTypeEnum.Integer;
                            this.multipleTokenParsing = false;
                            return true;
                        }
                        int generationNumber = (Integer)this.token;
                        this.moveNext();
                        if (this.tokenType != TokenTypeEnum.Reference) {
                            this.stream.seek(oldOffset);
                            this.token = objectNumber;
                            this.tokenType = TokenTypeEnum.Integer;
                            this.multipleTokenParsing = false;
                            return true;
                        }
                        this.token = new Reference(objectNumber, generationNumber);
                        this.multipleTokenParsing = false;
                        return true;
                    }
                }
                buffer = new StringBuilder();
                try {
                    while (true) {
                        buffer.append((char)c);
                        c = this.stream.readUnsignedByte();
                        if (c == 46) {
                            this.tokenType = TokenTypeEnum.Real;
                            continue;
                        }
                        if (c < 48 || c > 57) break;
                    }
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed number object).", e, this.stream.getPosition());
                }
                this.stream.skip(-1L);
                break;
            }
            case 91: {
                this.tokenType = TokenTypeEnum.ArrayBegin;
                break;
            }
            case 93: {
                this.tokenType = TokenTypeEnum.ArrayEnd;
                break;
            }
            case 60: {
                try {
                    c = this.stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (isolated opening angle-bracket character).", e, this.stream.getPosition());
                }
                if (c == 60) {
                    this.tokenType = TokenTypeEnum.DictionaryBegin;
                    break;
                }
                this.tokenType = TokenTypeEnum.Hex;
                buffer = new StringBuilder();
                try {
                    while (c != 62) {
                        buffer.append((char)c);
                        c = this.stream.readUnsignedByte();
                    }
                    break;
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed hex string).", e, this.stream.getPosition());
                }
            }
            case 62: {
                try {
                    c = this.stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed dictionary).", e, this.stream.getPosition());
                }
                if (c != 62) {
                    throw new FileFormatException("Malformed dictionary.", this.stream.getPosition());
                }
                this.tokenType = TokenTypeEnum.DictionaryEnd;
                break;
            }
            case 37: {
                this.tokenType = TokenTypeEnum.Comment;
                try {
                    while (!Parser.isEOL(c = this.stream.readUnsignedByte())) {
                    }
                }
                catch (EOFException e) {}
                break;
            }
            case 40: {
                this.tokenType = TokenTypeEnum.Literal;
                buffer = new StringBuilder();
                int level = 0;
                try {
                    while (true) {
                        if ((c = this.stream.readUnsignedByte()) == 40) {
                            ++level;
                        } else if (c == 41) {
                            --level;
                        } else if (c == 92) {
                            boolean lineBreak = false;
                            c = this.stream.readUnsignedByte();
                            switch (c) {
                                case 110: {
                                    c = 10;
                                    break;
                                }
                                case 114: {
                                    c = 13;
                                    break;
                                }
                                case 116: {
                                    c = 9;
                                    break;
                                }
                                case 98: {
                                    c = 8;
                                    break;
                                }
                                case 102: {
                                    c = 12;
                                    break;
                                }
                                case 40: 
                                case 41: 
                                case 92: {
                                    break;
                                }
                                case 13: {
                                    lineBreak = true;
                                    c = this.stream.readUnsignedByte();
                                    if (c == 10) break;
                                    this.stream.skip(-1L);
                                    break;
                                }
                                case 10: {
                                    lineBreak = true;
                                    break;
                                }
                                default: {
                                    if (c < 48 || c > 55) break;
                                    int octal = c - 48;
                                    c = this.stream.readUnsignedByte();
                                    if (c < 48 || c > 55) {
                                        c = octal;
                                        this.stream.skip(-1L);
                                        break;
                                    }
                                    octal = (octal << 3) + c - 48;
                                    c = this.stream.readUnsignedByte();
                                    if (c < 48 || c > 55) {
                                        c = octal;
                                        this.stream.skip(-1L);
                                        break;
                                    }
                                    octal = (octal << 3) + c - 48;
                                    c = octal & 0xFF;
                                }
                            }
                            if (lineBreak) {
                                continue;
                            }
                        } else if (c == 13 && (c = this.stream.readUnsignedByte()) != 10) {
                            c = 10;
                            this.stream.skip(-1L);
                        }
                        if (level == -1) break block9;
                        buffer.append((char)c);
                    }
                }
                catch (EOFException e) {
                    throw new FileFormatException("Unexpected EOF (malformed literal string).", e, this.stream.getPosition());
                }
            }
            case 82: {
                this.tokenType = TokenTypeEnum.Reference;
                break;
            }
            default: {
                this.tokenType = TokenTypeEnum.Keyword;
                buffer = new StringBuilder();
                try {
                    do {
                        buffer.append((char)c);
                    } while (!Parser.isDelimiter(c = this.stream.readUnsignedByte()) && !Parser.isWhitespace(c));
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                this.stream.skip(-1L);
            }
        }
        if (buffer != null) {
            switch (this.tokenType) {
                case Keyword: {
                    this.token = buffer.toString();
                    if (((String)this.token).equals("false") || ((String)this.token).equals("true")) {
                        this.tokenType = TokenTypeEnum.Boolean;
                        this.token = Boolean.parseBoolean((String)this.token);
                        break;
                    }
                    if (!((String)this.token).equals("null")) break;
                    this.tokenType = TokenTypeEnum.Null;
                    this.token = null;
                    break;
                }
                case Hex: 
                case Name: 
                case Comment: {
                    this.token = buffer.toString();
                    break;
                }
                case Literal: {
                    this.token = buffer.toString();
                    if (!((String)this.token).startsWith("D:")) break;
                    this.tokenType = TokenTypeEnum.Date;
                    this.token = PdfDate.toDate((String)this.token);
                    break;
                }
                case Integer: {
                    this.token = Integer.parseInt(buffer.toString());
                    break;
                }
                case Real: {
                    this.token = Float.valueOf(Float.parseFloat(buffer.toString()));
                }
            }
        }
        return true;
    }

    public PdfDataObject parsePdfObject() throws FileFormatException {
        switch (this.tokenType) {
            case Integer: {
                return new PdfInteger((Integer)this.token);
            }
            case Name: {
                return new PdfName((String)this.token, true);
            }
            case Reference: {
                return new PdfReference((Reference)this.token, this.file);
            }
            case Literal: {
                try {
                    return new PdfTextString(((String)this.token).getBytes("ISO-8859-1"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DictionaryBegin: {
                PdfDictionary dictionary = new PdfDictionary();
                while (true) {
                    this.moveNext();
                    if (this.tokenType == TokenTypeEnum.DictionaryEnd) break;
                    PdfName key = (PdfName)this.parsePdfObject();
                    this.moveNext();
                    PdfDirectObject value = (PdfDirectObject)this.parsePdfObject();
                    dictionary.put(key, value);
                }
                int oldOffset = (int)this.stream.getPosition();
                this.moveNext();
                if (this.tokenType == TokenTypeEnum.Keyword && this.token.equals("stream")) {
                    long position = this.stream.getPosition();
                    int length = (Integer)((PdfInteger)File.resolve(dictionary.get(PdfName.Length))).getRawValue();
                    this.stream.seek(position);
                    this.skipWhitespace();
                    byte[] data = new byte[length];
                    try {
                        this.stream.read(data);
                    }
                    catch (EOFException e) {
                        throw new FileFormatException("Unexpected EOF (malformed stream object).", e, this.stream.getPosition());
                    }
                    this.moveNext();
                    return new PdfStream(dictionary, new Buffer(data));
                }
                this.stream.seek(oldOffset);
                return dictionary;
            }
            case ArrayBegin: {
                PdfArray array = new PdfArray();
                while (true) {
                    this.moveNext();
                    if (this.tokenType == TokenTypeEnum.ArrayEnd) break;
                    array.add((PdfDirectObject)this.parsePdfObject());
                }
                return array;
            }
            case Real: {
                return new PdfReal(((Float)this.token).floatValue());
            }
            case Boolean: {
                return new PdfBoolean((Boolean)this.token);
            }
            case Date: {
                return new PdfDate((Date)this.token);
            }
            case Hex: {
                try {
                    return new PdfString((String)this.token, PdfString.SerializationModeEnum.Hex);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case Null: {
                return null;
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)this.tokenType));
    }

    public String retrieveVersion() throws FileFormatException {
        String header;
        this.stream.seek(0L);
        try {
            header = this.stream.readString(10);
        }
        catch (EOFException e) {
            throw new FileFormatException("Unexpected EOF (malformed version data).", e, this.stream.getPosition());
        }
        if (!header.startsWith(PdfHeader)) {
            throw new FileFormatException("PDF header not found.", this.stream.getPosition());
        }
        return header.substring(PdfHeader.length(), PdfHeader.length() + 3);
    }

    public long retrieveXRefOffset() throws FileFormatException {
        return this.retrieveXRefOffset(this.stream.getLength());
    }

    public long retrieveXRefOffset(long offset) throws FileFormatException {
        int index;
        int chunkSize = 1024;
        long position = offset - 1024L;
        if (position < 0L) {
            position = 0L;
        }
        this.stream.seek(position);
        try {
            index = this.stream.readString(1024).lastIndexOf("startxref");
        }
        catch (EOFException e) {
            throw new FileFormatException("Unexpected EOF (malformed 'startxref' tag).", e, this.stream.getPosition());
        }
        if (index < 0) {
            throw new FileFormatException("PDF startxref not found.", this.stream.getPosition());
        }
        this.stream.seek(position + (long)index);
        this.moveNext();
        this.moveNext();
        if (this.tokenType != TokenTypeEnum.Integer) {
            throw new FileFormatException("PDF startxref malformed.", this.stream.getPosition());
        }
        return ((Integer)this.token).intValue();
    }

    public void seek(long position) {
        this.stream.seek(position);
    }

    public void skip(long offset) {
        this.stream.skip(offset);
    }

    public boolean skipWhitespace() {
        try {
            int b;
            while (Parser.isWhitespace(b = this.stream.readUnsignedByte())) {
            }
        }
        catch (EOFException e) {
            return false;
        }
        this.stream.skip(-1L);
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public class Reference {
        private final int generationNumber;
        private final int objectNumber;

        private Reference(int objectNumber, int generationNumber) {
            this.objectNumber = objectNumber;
            this.generationNumber = generationNumber;
        }

        public int getGenerationNumber() {
            return this.generationNumber;
        }

        public int getObjectNumber() {
            return this.objectNumber;
        }
    }
}

