/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class Rectangle
extends PdfObjectWrapper<PdfArray> {
    private static PdfArray normalize(PdfArray rectangle) {
        if (((IPdfNumber)((Object)rectangle.get(0))).getNumberValue() > ((IPdfNumber)((Object)rectangle.get(2))).getNumberValue()) {
            PdfDirectObject leftCoordinate = rectangle.get(2);
            rectangle.set(2, rectangle.get(0));
            rectangle.set(0, leftCoordinate);
        }
        if (((IPdfNumber)((Object)rectangle.get(1))).getNumberValue() > ((IPdfNumber)((Object)rectangle.get(3))).getNumberValue()) {
            PdfDirectObject bottomCoordinate = rectangle.get(3);
            rectangle.set(3, rectangle.get(1));
            rectangle.set(1, bottomCoordinate);
        }
        return rectangle;
    }

    public Rectangle(RectangularShape rectangle) {
        this(rectangle.getMinX(), rectangle.getMaxY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public Rectangle(Point2D lowerLeft, Point2D upperRight) {
        this(lowerLeft.getX(), upperRight.getY(), upperRight.getX() - lowerLeft.getX(), upperRight.getY() - lowerLeft.getY());
    }

    public Rectangle(double left, double top, double width, double height) {
        this(new PdfArray(new PdfReal(left), new PdfReal(top - height), new PdfReal(left + width), new PdfReal(top)));
    }

    public Rectangle(PdfDirectObject baseObject) {
        super(Rectangle.normalize((PdfArray)File.resolve(baseObject)), null);
    }

    @Override
    public Rectangle clone(Document context) {
        throw new NotImplementedException();
    }

    public double getBottom() {
        return ((IPdfNumber)((Object)((PdfArray)this.getBaseDataObject()).get(1))).getNumberValue();
    }

    public double getHeight() {
        return this.getTop() - this.getBottom();
    }

    public double getLeft() {
        return this.getX();
    }

    public double getRight() {
        return ((IPdfNumber)((Object)((PdfArray)this.getBaseDataObject()).get(2))).getNumberValue();
    }

    public double getTop() {
        return this.getY();
    }

    public double getWidth() {
        return this.getRight() - this.getLeft();
    }

    public double getX() {
        return ((IPdfNumber)((Object)((PdfArray)this.getBaseDataObject()).get(0))).getNumberValue();
    }

    public double getY() {
        return ((IPdfNumber)((Object)((PdfArray)this.getBaseDataObject()).get(3))).getNumberValue();
    }

    public void setBottom(double value) {
        ((IPdfNumber)((Object)((PdfArray)this.getBaseDataObject()).get(1))).setNumberValue(value);
    }

    public void setHeight(double value) {
        this.setBottom(this.getTop() - value);
    }

    public void setLeft(double value) {
        this.setX(value);
    }

    public void setRight(double value) {
        ((IPdfNumber)((Object)((PdfArray)this.getBaseDataObject()).get(2))).setNumberValue(value);
    }

    public void setTop(double value) {
        this.setY(value);
    }

    public void setWidth(double value) {
        this.setRight(this.getLeft() + value);
    }

    public void setX(double value) {
        ((IPdfNumber)((Object)((PdfArray)this.getBaseDataObject()).get(0))).setNumberValue(value);
    }

    public void setY(double value) {
        ((IPdfNumber)((Object)((PdfArray)this.getBaseDataObject()).get(3))).setNumberValue(value);
    }
}

