/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfString;

public class PdfTextString
extends PdfString {
    private static final String ISO88591Encoding = "ISO-8859-1";
    private static final String UTF16BEEncoding = "UTF-16BE";
    private String encoding;

    public PdfTextString() {
    }

    public PdfTextString(byte[] rawValue) {
        this.setRawValue(rawValue);
    }

    public PdfTextString(String value) {
        this.setValue(value);
    }

    @Override
    public Object clone(File context) {
        PdfTextString clone = (PdfTextString)super.clone();
        return clone;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Object getValue() {
        try {
            byte[] buffer;
            byte[] valueBytes = (byte[])this.getRawValue();
            if (this.encoding == UTF16BEEncoding) {
                buffer = new byte[valueBytes.length - 2];
                System.arraycopy(valueBytes, 2, buffer, 0, buffer.length);
            } else {
                buffer = valueBytes;
            }
            return new String(buffer, this.encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValue(Object value) {
        try {
            byte[] valueBytes = ((String)value).getBytes(UTF16BEEncoding);
            byte[] buffer = new byte[valueBytes.length + 2];
            buffer[0] = -2;
            buffer[1] = -1;
            System.arraycopy(valueBytes, 0, buffer, 2, valueBytes.length);
            this.setRawValue(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setRawValue(byte[] value) {
        this.encoding = value.length > 2 && value[0] == -2 && value[1] == -1 ? UTF16BEEncoding : ISO88591Encoding;
        super.setRawValue(value);
    }

    @Override
    public String toString() {
        return (String)this.getValue();
    }
}

