/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.bytes.Buffer;
import it.stefanochizzolini.clown.bytes.IBuffer;
import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.bytes.filters.Filter;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import java.util.Iterator;

public class PdfStream
extends PdfDataObject {
    private IBuffer body;
    private PdfDictionary header;

    public PdfStream() {
        this(new PdfDictionary(), new Buffer());
    }

    public PdfStream(PdfDictionary header) {
        this(header, new Buffer());
    }

    public PdfStream(IBuffer body) {
        this(new PdfDictionary(), body);
    }

    public PdfStream(PdfDictionary header, IBuffer body) {
        this.header = header;
        this.body = body;
    }

    @Override
    public Object clone(File context) {
        PdfStream clone = new PdfStream((PdfDictionary)this.header.clone(context), this.body.clone());
        return clone;
    }

    public IBuffer getBody() {
        return this.getBody(true);
    }

    public IBuffer getBody(boolean decode) {
        PdfDirectObject filterObj;
        if (decode && (filterObj = this.header.get(PdfName.Filter)) != null) {
            PdfDataObject filterDataObj = File.resolve(filterObj);
            if (filterDataObj instanceof PdfName) {
                this.body.decode(Filter.get((PdfName)filterDataObj));
            } else {
                Iterator<PdfDirectObject> filterObjIterator = ((PdfArray)filterDataObj).iterator();
                while (filterObjIterator.hasNext()) {
                    this.body.decode(Filter.get((PdfName)File.resolve(filterObjIterator.next())));
                }
            }
            this.header.put(PdfName.Filter, null);
        }
        return this.body;
    }

    public PdfDictionary getHeader() {
        return this.header;
    }

    @Override
    public void writeTo(IOutputStream stream) {
        int bodyLength;
        byte[] bodyData;
        boolean unencodedBody;
        PdfDirectObject filterObj = this.header.get(PdfName.Filter);
        if (filterObj == null) {
            unencodedBody = true;
            filterObj = PdfName.FlateDecode;
            bodyData = this.body.encode(Filter.get((PdfName)filterObj));
            bodyLength = bodyData.length;
            this.header.put(PdfName.Filter, filterObj);
        } else {
            unencodedBody = false;
            bodyData = this.body.toByteArray();
            bodyLength = (int)this.body.getLength();
        }
        this.header.put(PdfName.Length, new PdfInteger(bodyLength));
        this.header.writeTo(stream);
        if (unencodedBody) {
            ((PdfInteger)this.header.get(PdfName.Length)).setValue((int)this.body.getLength());
            this.header.put(PdfName.Filter, null);
        }
        stream.write("\nstream\n");
        stream.write(bodyData);
        stream.write("\nendstream");
    }
}

