/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.IPdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfObject;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.tokens.Parser;
import it.stefanochizzolini.clown.tokens.XRefEntry;

public class PdfIndirectObject
extends PdfObject
implements IPdfIndirectObject {
    private static final String UsageFree = "f";
    private static final String UsageInUse = "n";
    private PdfDataObject dataObject;
    private File file;
    private boolean original;
    private PdfReference reference;
    private XRefEntry xrefEntry;

    public PdfIndirectObject(File file, PdfDataObject dataObject, XRefEntry xrefEntry) {
        this.file = file;
        this.dataObject = dataObject;
        this.xrefEntry = xrefEntry;
        this.original = xrefEntry.getOffset() != 0;
        this.reference = new PdfReference(this, xrefEntry.getNumber(), xrefEntry.getGeneration());
    }

    public File getFile() {
        return this.file;
    }

    public int hashCode() {
        return this.reference.getID().hashCode() ^ this.file.hashCode();
    }

    public boolean isInUse() {
        return this.xrefEntry.getUsage() == XRefEntry.UsageEnum.InUse;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public void update() {
        if (this.original) {
            this.file.getIndirectObjects().update(this);
        }
    }

    @Override
    public void writeTo(IOutputStream stream) {
        stream.write(String.valueOf(this.reference.getID()) + " obj\n");
        this.getDataObject().writeTo(stream);
        stream.write("\nendobj\n");
    }

    @Override
    public Object clone(File context) {
        return context.getIndirectObjects().addExternal(this);
    }

    @Override
    public void delete() {
        if (this.file != null) {
            this.file.getIndirectObjects().remove(this.xrefEntry.getNumber());
        }
    }

    @Override
    public PdfDataObject getDataObject() {
        if (this.dataObject == null) {
            if (this.xrefEntry.getUsage() == XRefEntry.UsageEnum.Free) {
                return null;
            }
            try {
                Parser parser = this.file.getReader().getParser();
                parser.seek(this.xrefEntry.getOffset());
                parser.moveNext(4);
                this.dataObject = parser.parsePdfObject();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.dataObject;
    }

    @Override
    public PdfIndirectObject getIndirectObject() {
        return this;
    }

    @Override
    public PdfReference getReference() {
        return this.reference;
    }

    @Override
    public void setDataObject(PdfDataObject value) {
        if (this.xrefEntry.getGeneration() == 65535) {
            throw new RuntimeException("Unreusable entry.");
        }
        this.dataObject = value;
        this.xrefEntry.setUsage(XRefEntry.UsageEnum.InUse);
        this.update();
    }

    public void dropFile() {
        this.file = null;
    }

    public void dropOriginal() {
        this.original = false;
    }

    String getUsage() {
        switch (this.xrefEntry.getUsage()) {
            case Free: {
                return UsageFree;
            }
            case InUse: {
                return UsageInUse;
            }
        }
        throw new RuntimeException("Invalid xref usage value.");
    }
}

