/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PdfDictionary
extends PdfDirectObject
implements Map<PdfName, PdfDirectObject> {
    private HashMap<PdfName, PdfDirectObject> entries;

    public PdfDictionary() {
        this.entries = new HashMap();
    }

    public PdfDictionary(int capacity) {
        this.entries = new HashMap(capacity);
    }

    public PdfDictionary(PdfName[] keys, PdfDirectObject[] values) {
        this(values.length);
        int index = 0;
        while (index < values.length) {
            this.put(keys[index], values[index]);
            ++index;
        }
    }

    @Override
    public Object clone(File context) {
        PdfDictionary clone = new PdfDictionary(this.entries.size());
        for (Map.Entry<PdfName, PdfDirectObject> entry : this.entries.entrySet()) {
            clone.put(entry.getKey(), (PdfDirectObject)entry.getValue().clone(context));
        }
        return clone;
    }

    @Override
    public int compareTo(PdfDirectObject obj) {
        throw new NotImplementedException();
    }

    public PdfName getKey(PdfDirectObject value) {
        for (Map.Entry<PdfName, PdfDirectObject> entry : this.entries.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public PdfDataObject resolve(Object key) {
        return File.resolve(this.get(key));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<< ");
        for (Map.Entry<PdfName, PdfDirectObject> entry : this.entries.entrySet()) {
            buffer.append(entry.getKey().toString());
            buffer.append(" ");
            buffer.append(PdfDirectObject.toString(entry.getValue()));
            buffer.append(" ");
        }
        buffer.append(">>");
        return buffer.toString();
    }

    @Override
    public void writeTo(IOutputStream stream) {
        stream.write("<< ");
        for (Map.Entry<PdfName, PdfDirectObject> entry : this.entries.entrySet()) {
            entry.getKey().writeTo(stream);
            stream.write(" ");
            PdfDirectObject.writeTo(stream, entry.getValue());
            stream.write(" ");
        }
        stream.write(">>");
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entries.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.entries.containsValue(value);
    }

    @Override
    public Set<Map.Entry<PdfName, PdfDirectObject>> entrySet() {
        return this.entries.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof PdfDictionary && this.entrySet().equals(((PdfDictionary)object).entrySet());
    }

    @Override
    public PdfDirectObject get(Object key) {
        return this.entries.get(key);
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Set<PdfName> keySet() {
        return this.entries.keySet();
    }

    @Override
    public PdfDirectObject put(PdfName key, PdfDirectObject value) {
        return this.entries.put(key, value);
    }

    @Override
    public void putAll(Map<? extends PdfName, ? extends PdfDirectObject> entries) {
        this.entries.putAll(entries);
    }

    @Override
    public PdfDirectObject remove(Object key) {
        return this.entries.remove(key);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<PdfDirectObject> values() {
        return this.entries.values();
    }
}

