/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.objects;

import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfString;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PdfDate
extends PdfString {
    protected static final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssZ");

    public static Date toDate(String value) {
        value = value.substring(2);
        int length = value.length();
        switch (length) {
            case 8: {
                value = String.valueOf(value) + "000000+0000";
                break;
            }
            case 14: {
                value = String.valueOf(value) + "+0000";
                break;
            }
            case 15: {
                value = String.valueOf(value.substring(0, length - 1)) + "+0000";
                break;
            }
            case 17: {
                value = String.valueOf(value) + "00";
                break;
            }
            case 21: {
                value = value.substring(0, length - 1).replace("'", "");
            }
        }
        try {
            return formatter.parse(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PdfDate() {
    }

    public PdfDate(Date value) {
        this.setValue(value);
    }

    @Override
    public Object clone(File context) {
        PdfDate clone = (PdfDate)super.clone();
        return clone;
    }

    @Override
    public Object getValue() {
        try {
            return PdfDate.toDate(new String((byte[])this.getRawValue(), "ISO-8859-1"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValue(Object value) {
        byte[] valueBytes;
        try {
            valueBytes = formatter.format(value).getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] buffer = new byte[23];
        buffer[0] = 68;
        buffer[1] = 58;
        System.arraycopy(valueBytes, 0, buffer, 2, 17);
        buffer[19] = 39;
        System.arraycopy(valueBytes, 17, buffer, 20, 2);
        buffer[22] = 39;
        this.setRawValue(buffer);
    }
}

