/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.files;

import it.stefanochizzolini.clown.bytes.FileInputStream;
import it.stefanochizzolini.clown.bytes.IInputStream;
import it.stefanochizzolini.clown.bytes.IOutputStream;
import it.stefanochizzolini.clown.bytes.OutputStream;
import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.files.IndirectObjects;
import it.stefanochizzolini.clown.files.SerializationModeEnum;
import it.stefanochizzolini.clown.objects.IPdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfDataObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObject;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.tokens.FileFormatException;
import it.stefanochizzolini.clown.tokens.Reader;
import it.stefanochizzolini.clown.tokens.Writer;
import it.stefanochizzolini.clown.tokens.XRefEntry;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;

public class File
implements Closeable {
    private static Random hashCodeGenerator = new Random();
    private Document document;
    private int hashCode = hashCodeGenerator.nextInt();
    private IndirectObjects indirectObjects;
    private Reader reader;
    private PdfDictionary trailer;
    private String version;
    private XRefEntry[] xrefEntries;
    private String path;

    public static PdfDataObject resolve(PdfObject object) {
        if (object instanceof IPdfIndirectObject) {
            return ((IPdfIndirectObject)((Object)object)).getDataObject();
        }
        return (PdfDataObject)object;
    }

    public static <T extends PdfDataObject> ResolvedObject<T> resolve(PdfObject object, IPdfIndirectObject container) {
        if (object == null) {
            return null;
        }
        if (object instanceof IPdfIndirectObject) {
            IPdfIndirectObject indirectObject = (IPdfIndirectObject)((Object)object);
            return new ResolvedObject(indirectObject.getDataObject(), indirectObject.getIndirectObject(), null);
        }
        return new ResolvedObject((PdfDataObject)object, container.getIndirectObject(), null);
    }

    public static boolean update(PdfDirectObject object) {
        if (object instanceof PdfReference) {
            ((PdfReference)object).getIndirectObject().update();
            return true;
        }
        return false;
    }

    public File() {
        this.version = "1.6";
        this.trailer = new PdfDictionary();
        this.indirectObjects = new IndirectObjects(this, null);
        this.document = new Document(this);
    }

    public File(String path) throws FileFormatException, FileNotFoundException {
        this(new FileInputStream(new RandomAccessFile(path, "r")));
        this.path = path;
    }

    public File(IInputStream stream) throws FileFormatException {
        this.reader = new Reader(stream, this);
        this.version = this.reader.readVersion();
        this.trailer = this.reader.readTrailer();
        if (this.trailer.containsKey(PdfName.Encrypt)) {
            throw new NotImplementedException("Encrypted files are currently not supported.");
        }
        this.xrefEntries = this.reader.readXRefTable(this.trailer);
        this.indirectObjects = new IndirectObjects(this, this.xrefEntries);
        this.document = new Document(this.trailer.get(PdfName.Root));
    }

    public Document getDocument() {
        return this.document;
    }

    public IndirectObjects getIndirectObjects() {
        return this.indirectObjects;
    }

    public Reader getReader() {
        return this.reader;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    public String getVersion() {
        return this.version;
    }

    public XRefEntry[] getXRefEntries() {
        return this.xrefEntries;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public PdfReference register(PdfDataObject object) {
        return this.indirectObjects.add(object).getReference();
    }

    public void save() throws IOException {
        this.save(SerializationModeEnum.Standard);
    }

    public void save(SerializationModeEnum mode) throws IOException {
        if (!new java.io.File(this.path).exists()) {
            throw new FileNotFoundException("No valid source path available: use writeTo instead.");
        }
        this.writeTo(this.getTempPath(), mode);
    }

    public void unregister(PdfReference reference) {
        this.indirectObjects.remove(reference.getObjectNumber());
    }

    public void writeTo(String path, SerializationModeEnum mode) throws IOException {
        this.writeTo(new java.io.File(path), mode);
    }

    public void writeTo(java.io.File file, SerializationModeEnum mode) throws IOException {
        OutputStream outputStream;
        BufferedOutputStream baseOutputStream;
        try {
            file.createNewFile();
            baseOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            outputStream = new OutputStream(baseOutputStream);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(file.getPath()) + " file couldn't be created.", e);
        }
        try {
            this.writeTo(outputStream, mode);
            baseOutputStream.flush();
            baseOutputStream.close();
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(file.getPath()) + " file writing has failed.", e);
        }
    }

    public void writeTo(IOutputStream stream, SerializationModeEnum mode) {
        Writer writer = new Writer(stream, this);
        switch (mode) {
            case Incremental: {
                if (this.reader != null) {
                    writer.writeIncremental();
                    break;
                }
            }
            case Standard: {
                writer.writeStandard();
                break;
            }
            case Linearized: {
                throw new NotImplementedException();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            java.io.File sourceFile = new java.io.File(this.getTempPath());
            if (sourceFile.exists()) {
                java.io.File targetFile = new java.io.File(this.path);
                targetFile.delete();
                sourceFile.renameTo(targetFile);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private String getTempPath() {
        return this.path == null ? null : String.valueOf(this.path) + ".tmp";
    }

    public static final class ResolvedObject<T extends PdfDataObject> {
        public final T dataObject;
        public final PdfIndirectObject container;

        private ResolvedObject(T dataObject, PdfIndirectObject container) {
            this.dataObject = dataObject;
            this.container = container;
        }

        /* synthetic */ ResolvedObject(PdfDataObject pdfDataObject, PdfIndirectObject pdfIndirectObject, ResolvedObject resolvedObject) {
            this(pdfDataObject, pdfIndirectObject);
        }
    }
}

