/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interchange.metadata;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfAtomicObject;
import it.stefanochizzolini.clown.objects.PdfDate;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.util.NotImplementedException;
import java.util.Date;

public class Information
extends PdfObjectWrapper<PdfDictionary> {
    public Information(Document context) {
        super(context.getFile(), new PdfDictionary());
        try {
            Package package_ = this.getClass().getPackage();
            this.setProducer(String.valueOf(package_.getSpecificationTitle()) + " " + package_.getSpecificationVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Information(PdfDirectObject baseObject) {
        super(baseObject, null);
    }

    public String getAuthor() {
        return (String)this.getEntry(PdfName.Author);
    }

    @Override
    public Information clone(Document context) {
        throw new NotImplementedException();
    }

    public Date getCreationDate() {
        return (Date)this.getEntry(PdfName.CreationDate);
    }

    public String getCreator() {
        return (String)this.getEntry(PdfName.Creator);
    }

    public String getKeywords() {
        return (String)this.getEntry(PdfName.Keywords);
    }

    public Date getModificationDate() {
        return (Date)this.getEntry(PdfName.ModDate);
    }

    public String getProducer() {
        return (String)this.getEntry(PdfName.Producer);
    }

    public String getSubject() {
        return (String)this.getEntry(PdfName.Subject);
    }

    public String getTitle() {
        return (String)this.getEntry(PdfName.Title);
    }

    public void setAuthor(String value) {
        this.setEntry(PdfName.Author, value, PdfTextString.class);
    }

    public void setCreationDate(Date value) {
        this.setEntry(PdfName.CreationDate, value, PdfDate.class);
    }

    public void setCreator(String value) {
        this.setEntry(PdfName.Creator, value, PdfTextString.class);
    }

    public void setKeywords(String value) {
        this.setEntry(PdfName.Keywords, value, PdfTextString.class);
    }

    public void setModificationDate(Date value) {
        this.setEntry(PdfName.ModDate, value, PdfDate.class);
    }

    public void setProducer(String value) {
        this.setEntry(PdfName.Producer, value, PdfTextString.class);
    }

    public void setSubject(String value) {
        this.setEntry(PdfName.Subject, value, PdfTextString.class);
    }

    public void setTitle(String value) {
        this.setEntry(PdfName.Title, value, PdfTextString.class);
    }

    protected <TPdf extends PdfAtomicObject<?>> Object getEntry(PdfName key) {
        PdfAtomicObject entry = (PdfAtomicObject)File.resolve(((PdfDictionary)this.getBaseDataObject()).get(key));
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    protected <TPdf extends PdfAtomicObject<?>> void setEntry(PdfName key, Object value, Class<TPdf> entryType) {
        PdfAtomicObject entry = (PdfAtomicObject)File.resolve(((PdfDictionary)this.getBaseDataObject()).get(key));
        if (entry == null) {
            try {
                entry = (PdfAtomicObject)entryType.newInstance();
                ((PdfDictionary)this.getBaseDataObject()).put(key, entry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        entry.setValue(value);
    }
}

