/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.viewer;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfAtomicObject;
import it.stefanochizzolini.clown.objects.PdfBoolean;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.util.NotImplementedException;

public class ViewerPreferences
extends PdfObjectWrapper<PdfDictionary> {
    public ViewerPreferences(Document context) {
        super(context.getFile(), new PdfDictionary());
    }

    public ViewerPreferences(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public ViewerPreferences clone(Document context) {
        throw new NotImplementedException();
    }

    public DirectionEnum getDirection() {
        PdfName directionObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Direction);
        if (directionObject == null) {
            return DirectionEnum.LeftToRight;
        }
        return DirectionEnum.get(directionObject);
    }

    public boolean isCenterWindow() {
        return (Boolean)this.getEntry(PdfName.CenterWindow);
    }

    public boolean isDisplayDocTitle() {
        return (Boolean)this.getEntry(PdfName.DisplayDocTitle);
    }

    public boolean isFitWindow() {
        return (Boolean)this.getEntry(PdfName.FitWindow);
    }

    public boolean isHideMenubar() {
        return (Boolean)this.getEntry(PdfName.HideMenubar);
    }

    public boolean isHideToolbar() {
        return (Boolean)this.getEntry(PdfName.HideToolbar);
    }

    public boolean isHideWindowUI() {
        return (Boolean)this.getEntry(PdfName.HideWindowUI);
    }

    public void setCenterWindow(boolean value) {
        this.setEntry(PdfName.CenterWindow, value, PdfBoolean.class);
    }

    public void setDirection(DirectionEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Direction, value.getCode());
    }

    public void setDisplayDocTitle(boolean value) {
        this.setEntry(PdfName.DisplayDocTitle, value, PdfBoolean.class);
    }

    public void setFitWindow(boolean value) {
        this.setEntry(PdfName.FitWindow, value, PdfBoolean.class);
    }

    public void setHideMenubar(boolean value) {
        this.setEntry(PdfName.HideMenubar, value, PdfBoolean.class);
    }

    public void setHideToolbar(boolean value) {
        this.setEntry(PdfName.HideToolbar, value, PdfBoolean.class);
    }

    public void setHideWindowUI(boolean value) {
        this.setEntry(PdfName.HideWindowUI, value, PdfBoolean.class);
    }

    protected <T, TPdf extends PdfAtomicObject<T>> T getEntry(PdfName key) {
        PdfAtomicObject entry = (PdfAtomicObject)File.resolve(((PdfDictionary)this.getBaseDataObject()).get(key));
        if (entry == null) {
            return null;
        }
        return (T)entry.getValue();
    }

    protected <T, TPdf extends PdfAtomicObject<T>> void setEntry(PdfName key, T value, Class<TPdf> entryType) {
        PdfAtomicObject entry = (PdfAtomicObject)File.resolve(((PdfDictionary)this.getBaseDataObject()).get(key));
        if (entry == null) {
            try {
                entry = (PdfAtomicObject)entryType.newInstance();
                ((PdfDictionary)this.getBaseDataObject()).put(key, entry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        entry.setValue(value);
    }

    public static enum DirectionEnum {
        LeftToRight(PdfName.L2R),
        RightToLeft(PdfName.R2L);

        private final PdfName code;

        public static DirectionEnum get(PdfName value) {
            DirectionEnum[] directionEnumArray = DirectionEnum.values();
            int n = directionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirectionEnum direction = directionEnumArray[n2];
                if (direction.getCode().equals(value)) {
                    return direction;
                }
                ++n2;
            }
            return null;
        }

        private DirectionEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

