/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.navigation.page;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.objects.IPdfNumber;
import it.stefanochizzolini.clown.objects.PdfAtomicObject;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfIndirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.util.NotImplementedException;

public class Transition
extends PdfObjectWrapper<PdfDictionary> {
    public Transition(Document context) {
        super(context.getFile(), new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Trans}));
    }

    public Transition(Document context, StyleEnum style) {
        this(context, style, null, null, null, null, null);
    }

    public Transition(Document context, StyleEnum style, Double duration) {
        this(context, style, duration, null, null, null, null);
    }

    public Transition(Document context, StyleEnum style, Double duration, OrientationEnum orientation, PageDirectionEnum pageDirection, DirectionEnum direction, Double scale) {
        this(context);
        this.setStyle(style);
        this.setDuration(duration);
        this.setOrientation(orientation);
        this.setPageDirection(pageDirection);
        this.setDirection(direction);
        this.setScale(scale);
    }

    public Transition(PdfDirectObject baseObject, PdfIndirectObject container) {
        super(baseObject, container);
    }

    @Override
    public Transition clone(Document context) {
        throw new NotImplementedException();
    }

    public DirectionEnum getDirection() {
        PdfAtomicObject directionObject = (PdfAtomicObject)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Di);
        if (directionObject == null) {
            return DirectionEnum.LeftToRight;
        }
        return DirectionEnum.get(directionObject);
    }

    public Double getDuration() {
        IPdfNumber durationObject = (IPdfNumber)((Object)((PdfDictionary)this.getBaseDataObject()).get(PdfName.D));
        if (durationObject == null) {
            return new Double(1.0);
        }
        return durationObject.getNumberValue();
    }

    public OrientationEnum getOrientation() {
        PdfName orientationObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Dm);
        if (orientationObject == null) {
            return OrientationEnum.Horizontal;
        }
        return OrientationEnum.get(orientationObject);
    }

    public PageDirectionEnum getPageDirection() {
        PdfName pageDirectionObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.M);
        if (pageDirectionObject == null) {
            return PageDirectionEnum.Inward;
        }
        return PageDirectionEnum.get(pageDirectionObject);
    }

    public Double getScale() {
        IPdfNumber scaleObject = (IPdfNumber)((Object)((PdfDictionary)this.getBaseDataObject()).get(PdfName.SS));
        if (scaleObject == null) {
            return new Double(1.0);
        }
        return scaleObject.getNumberValue();
    }

    public StyleEnum getStyle() {
        PdfName styleObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.S);
        if (styleObject == null) {
            return StyleEnum.Replace;
        }
        return StyleEnum.get(styleObject);
    }

    public void setDirection(DirectionEnum value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Di);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Di, value.getCode());
        }
    }

    public void setDuration(Double value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.D);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, new PdfReal(value));
        }
    }

    public void setOrientation(OrientationEnum value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dm);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Dm, value.getCode());
        }
    }

    public void setPageDirection(PageDirectionEnum value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.M);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.M, value.getCode());
        }
    }

    public void setScale(Double value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.SS);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.SS, new PdfReal(value));
        }
    }

    public void setStyle(StyleEnum value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.S);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.S, value.getCode());
        }
    }

    public static enum DirectionEnum {
        LeftToRight(new PdfInteger(0)),
        BottomToTop(new PdfInteger(90)),
        RightToLeft(new PdfInteger(180)),
        TopToBottom(new PdfInteger(270)),
        TopLeftToBottomRight(new PdfInteger(315)),
        None(PdfName.None);

        private final PdfAtomicObject<?> code;

        public static DirectionEnum get(PdfAtomicObject<?> value) {
            DirectionEnum[] directionEnumArray = DirectionEnum.values();
            int n = directionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirectionEnum direction = directionEnumArray[n2];
                if (direction.getCode().equals(value)) {
                    return direction;
                }
                ++n2;
            }
            return null;
        }

        private DirectionEnum(PdfAtomicObject<?> code) {
            this.code = code;
        }

        public PdfAtomicObject<?> getCode() {
            return this.code;
        }
    }

    public static enum OrientationEnum {
        Horizontal(PdfName.H),
        Vertical(PdfName.V);

        private final PdfName code;

        public static OrientationEnum get(PdfName value) {
            OrientationEnum[] orientationEnumArray = OrientationEnum.values();
            int n = orientationEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrientationEnum orientation = orientationEnumArray[n2];
                if (orientation.getCode().equals(value)) {
                    return orientation;
                }
                ++n2;
            }
            return null;
        }

        private OrientationEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }

    public static enum PageDirectionEnum {
        Inward(PdfName.I),
        Outward(PdfName.O);

        private final PdfName code;

        public static PageDirectionEnum get(PdfName value) {
            PageDirectionEnum[] pageDirectionEnumArray = PageDirectionEnum.values();
            int n = pageDirectionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                PageDirectionEnum direction = pageDirectionEnumArray[n2];
                if (direction.getCode().equals(value)) {
                    return direction;
                }
                ++n2;
            }
            return null;
        }

        private PageDirectionEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }

    public static enum StyleEnum {
        Split(PdfName.Split),
        Blinds(PdfName.Blinds),
        Box(PdfName.Box),
        Wipe(PdfName.Wipe),
        Dissolve(PdfName.Dissolve),
        Glitter(PdfName.Glitter),
        Replace(PdfName.R),
        Fly(PdfName.Fly),
        Push(PdfName.Push),
        Cover(PdfName.Cover),
        Uncover(PdfName.Uncover),
        Fade(PdfName.Fade);

        private final PdfName code;

        public static StyleEnum get(PdfName value) {
            StyleEnum[] styleEnumArray = StyleEnum.values();
            int n = styleEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleEnum style = styleEnumArray[n2];
                if (style.getCode().equals(value)) {
                    return style;
                }
                ++n2;
            }
            return null;
        }

        private StyleEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

