/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.navigation.document;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.interaction.ILink;
import it.stefanochizzolini.clown.documents.interaction.actions.Action;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.Bookmarks;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.Destination;
import it.stefanochizzolini.clown.documents.interaction.navigation.document.LocalDestination;
import it.stefanochizzolini.clown.files.File;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfObjectWrapper;
import it.stefanochizzolini.clown.objects.PdfReference;
import it.stefanochizzolini.clown.objects.PdfTextString;
import it.stefanochizzolini.clown.util.NotImplementedException;

public class Bookmark
extends PdfObjectWrapper<PdfDictionary>
implements ILink {
    public Bookmark(Document context, String title) {
        super(context.getFile(), new PdfDictionary());
        this.setTitle(title);
    }

    public Bookmark(Document context, String title, LocalDestination destination) {
        this(context, title);
        this.setDestination(destination);
    }

    public Bookmark(Document context, String title, Action action) {
        this(context, title);
        this.setAction(action);
    }

    Bookmark(PdfDirectObject baseObject) {
        super(baseObject, null);
    }

    @Override
    public Bookmark clone(Document context) {
        throw new NotImplementedException();
    }

    public Bookmarks getBookmarks() {
        return new Bookmarks(this.getBaseObject());
    }

    public Bookmark getParent() {
        PdfReference reference = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Parent);
        if (((PdfDictionary)File.resolve(reference)).containsKey(PdfName.Title)) {
            return new Bookmark(reference);
        }
        return null;
    }

    public String getTitle() {
        return (String)((PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Title)).getValue();
    }

    public boolean isExpanded() {
        PdfInteger countObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Count);
        return countObject == null || (Integer)countObject.getRawValue() >= 0;
    }

    public void setExpanded(boolean value) {
        PdfInteger countObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Count);
        if (countObject == null) {
            return;
        }
        countObject.setRawValue((value ? 1 : -1) * Math.abs((Integer)countObject.getRawValue()));
    }

    public void setTitle(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Title, new PdfTextString(value));
    }

    @Override
    public Action getAction() {
        PdfDirectObject actionObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
        if (actionObject == null) {
            return null;
        }
        return Action.wrap(actionObject, this.getContainer());
    }

    @Override
    public Destination getDestination() {
        PdfDirectObject destinationObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Dest);
        if (destinationObject == null) {
            return null;
        }
        return Document.resolveName(LocalDestination.class, destinationObject, this.getContainer());
    }

    @Override
    public PdfObjectWrapper<?> getTarget() {
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.Dest)) {
            return this.getDestination();
        }
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.A)) {
            return this.getAction();
        }
        return null;
    }

    @Override
    public void setAction(Action value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.A);
        } else {
            if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.Dest)) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dest);
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, value.getBaseObject());
        }
    }

    @Override
    public void setDestination(Destination value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dest);
        } else {
            if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.A)) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.A);
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Dest, value.getNamedBaseObject());
        }
    }

    @Override
    public void setTarget(PdfObjectWrapper<?> value) {
        if (value instanceof Destination) {
            this.setDestination((Destination)value);
        } else if (value instanceof Action) {
            this.setAction((Action)value);
        } else {
            throw new IllegalArgumentException("It MUST be either a Destination or an Action.");
        }
    }
}

