/*
 * Decompiled with CFR 0.152.
 */
package it.stefanochizzolini.clown.documents.interaction.forms.styles;

import it.stefanochizzolini.clown.documents.Document;
import it.stefanochizzolini.clown.documents.contents.colorSpaces.DeviceRGBColor;
import it.stefanochizzolini.clown.documents.contents.composition.AlignmentXEnum;
import it.stefanochizzolini.clown.documents.contents.composition.AlignmentYEnum;
import it.stefanochizzolini.clown.documents.contents.composition.BlockFilter;
import it.stefanochizzolini.clown.documents.contents.composition.PrimitiveFilter;
import it.stefanochizzolini.clown.documents.contents.fonts.StandardType1Font;
import it.stefanochizzolini.clown.documents.contents.xObjects.FormXObject;
import it.stefanochizzolini.clown.documents.interaction.annotations.Appearance;
import it.stefanochizzolini.clown.documents.interaction.annotations.AppearanceStates;
import it.stefanochizzolini.clown.documents.interaction.annotations.DualWidget;
import it.stefanochizzolini.clown.documents.interaction.annotations.Widget;
import it.stefanochizzolini.clown.documents.interaction.forms.CheckBox;
import it.stefanochizzolini.clown.documents.interaction.forms.ChoiceItem;
import it.stefanochizzolini.clown.documents.interaction.forms.ComboBox;
import it.stefanochizzolini.clown.documents.interaction.forms.Field;
import it.stefanochizzolini.clown.documents.interaction.forms.ListBox;
import it.stefanochizzolini.clown.documents.interaction.forms.PushButton;
import it.stefanochizzolini.clown.documents.interaction.forms.RadioButton;
import it.stefanochizzolini.clown.documents.interaction.forms.TextField;
import it.stefanochizzolini.clown.documents.interaction.forms.styles.FieldStyle;
import it.stefanochizzolini.clown.objects.PdfArray;
import it.stefanochizzolini.clown.objects.PdfDictionary;
import it.stefanochizzolini.clown.objects.PdfDirectObject;
import it.stefanochizzolini.clown.objects.PdfInteger;
import it.stefanochizzolini.clown.objects.PdfName;
import it.stefanochizzolini.clown.objects.PdfReal;
import it.stefanochizzolini.clown.objects.PdfString;
import it.stefanochizzolini.clown.util.math.geom.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DefaultStyle
extends FieldStyle {
    public DefaultStyle() {
        this.setBackColor(new DeviceRGBColor(0.9, 0.9, 0.9));
    }

    @Override
    public void apply(Field field) {
        if (field instanceof PushButton) {
            this.apply((PushButton)field);
        } else if (field instanceof CheckBox) {
            this.apply((CheckBox)field);
        } else if (field instanceof TextField) {
            this.apply((TextField)field);
        } else if (field instanceof ComboBox) {
            this.apply((ComboBox)field);
        } else if (field instanceof ListBox) {
            this.apply((ListBox)field);
        } else if (field instanceof RadioButton) {
            this.apply((RadioButton)field);
        }
    }

    private void apply(CheckBox field) {
        Document document = field.getDocument();
        for (Widget widget : field.getWidgets()) {
            PdfDictionary widgetDataObject = (PdfDictionary)widget.getBaseDataObject();
            widgetDataObject.put(PdfName.DA, new PdfString("/ZaDb 0 Tf 0 0 0 rg"));
            widgetDataObject.put(PdfName.MK, new PdfDictionary(new PdfName[]{PdfName.BG, PdfName.BC, PdfName.CA}, new PdfDirectObject[]{new PdfArray(new PdfReal(0.9412), new PdfReal(0.9412), new PdfReal(0.9412)), new PdfArray(new PdfInteger(0), new PdfInteger(0), new PdfInteger(0)), new PdfString("4")}));
            widgetDataObject.put(PdfName.BS, new PdfDictionary(new PdfName[]{PdfName.W, PdfName.S}, new PdfDirectObject[]{new PdfReal(0.8), PdfName.S}));
            widgetDataObject.put(PdfName.H, PdfName.P);
            Appearance appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new Appearance(document);
                widget.setAppearance(appearance);
            }
            AppearanceStates normalAppearance = appearance.getNormal();
            FormXObject onState = new FormXObject(document);
            normalAppearance.put(PdfName.Yes, onState);
            Rectangle2D widgetBox = widget.getBox();
            Dimension size = new Dimension(widgetBox.getWidth(), widgetBox.getHeight());
            Rectangle2D.Double frame = new Rectangle2D.Double(0.0, 0.0, ((Dimension2D)size).getWidth(), ((Dimension2D)size).getHeight());
            onState.setSize(size);
            PrimitiveFilter builder = new PrimitiveFilter(onState);
            builder.beginLocalState();
            builder.setFillColor(this.getBackColor());
            builder.setStrokeColor(this.getForeColor());
            builder.drawRectangle(frame);
            builder.fillStroke();
            builder.end();
            BlockFilter blockFilter = new BlockFilter(builder);
            blockFilter.begin(frame, AlignmentXEnum.Center, AlignmentYEnum.Middle);
            builder.setFillColor(this.getForeColor());
            builder.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.ZapfDingbats, true, false), ((Dimension2D)size).getHeight() * 0.8);
            blockFilter.showText(new String(new char[]{this.getCheckSymbol()}));
            blockFilter.end();
            builder.flush();
            FormXObject offState = new FormXObject(document);
            normalAppearance.put(PdfName.Off, offState);
            offState.setSize(size);
            PrimitiveFilter builder2 = new PrimitiveFilter(offState);
            builder2.beginLocalState();
            builder2.setFillColor(this.getBackColor());
            builder2.setStrokeColor(this.getForeColor());
            builder2.drawRectangle(frame);
            builder2.fillStroke();
            builder2.end();
            builder2.flush();
        }
    }

    private void apply(RadioButton field) {
        Document document = field.getDocument();
        for (Widget widget : field.getWidgets()) {
            PdfDictionary widgetDataObject = (PdfDictionary)widget.getBaseDataObject();
            widgetDataObject.put(PdfName.DA, new PdfString("/ZaDb 0 Tf 0 0 0 rg"));
            widgetDataObject.put(PdfName.MK, new PdfDictionary(new PdfName[]{PdfName.BG, PdfName.BC, PdfName.CA}, new PdfDirectObject[]{new PdfArray(new PdfReal(0.9412), new PdfReal(0.9412), new PdfReal(0.9412)), new PdfArray(new PdfInteger(0), new PdfInteger(0), new PdfInteger(0)), new PdfString("l")}));
            widgetDataObject.put(PdfName.BS, new PdfDictionary(new PdfName[]{PdfName.W, PdfName.S}, new PdfDirectObject[]{new PdfReal(0.8), PdfName.S}));
            widgetDataObject.put(PdfName.H, PdfName.P);
            Appearance appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new Appearance(document);
                widget.setAppearance(appearance);
            }
            AppearanceStates normalAppearance = appearance.getNormal();
            FormXObject onState = normalAppearance.get(new PdfName(((DualWidget)widget).getWidgetName()));
            Rectangle2D widgetBox = widget.getBox();
            Dimension size = new Dimension(widgetBox.getWidth(), widgetBox.getHeight());
            Rectangle2D.Double frame = new Rectangle2D.Double(1.0, 1.0, ((Dimension2D)size).getWidth() - 2.0, ((Dimension2D)size).getHeight() - 2.0);
            onState.setSize(size);
            PrimitiveFilter builder = new PrimitiveFilter(onState);
            builder.beginLocalState();
            builder.setFillColor(this.getBackColor());
            builder.setStrokeColor(this.getForeColor());
            builder.drawEllipse(frame);
            builder.fillStroke();
            builder.end();
            BlockFilter blockFilter = new BlockFilter(builder);
            blockFilter.begin(frame, AlignmentXEnum.Center, AlignmentYEnum.Middle);
            builder.setFillColor(this.getForeColor());
            builder.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.ZapfDingbats, true, false), ((Dimension2D)size).getHeight() * 0.8);
            blockFilter.showText(new String(new char[]{this.getRadioSymbol()}));
            blockFilter.end();
            builder.flush();
            FormXObject offState = new FormXObject(document);
            normalAppearance.put(PdfName.Off, offState);
            offState.setSize(size);
            PrimitiveFilter builder2 = new PrimitiveFilter(offState);
            builder2.beginLocalState();
            builder2.setFillColor(this.getBackColor());
            builder2.setStrokeColor(this.getForeColor());
            builder2.drawEllipse(frame);
            builder2.fillStroke();
            builder2.end();
            builder2.flush();
        }
    }

    private void apply(PushButton field) {
        Document document = field.getDocument();
        Widget widget = field.getWidgets().get(0);
        Appearance appearance = widget.getAppearance();
        if (appearance == null) {
            appearance = new Appearance(document);
            widget.setAppearance(appearance);
        }
        FormXObject normalAppearanceState = new FormXObject(document);
        Rectangle2D widgetBox = widget.getBox();
        Dimension size = new Dimension(widgetBox.getWidth(), widgetBox.getHeight());
        normalAppearanceState.setSize(size);
        PrimitiveFilter builder = new PrimitiveFilter(normalAppearanceState);
        builder.beginLocalState();
        double lineWidth = 1.0;
        builder.setLineWidth(lineWidth);
        builder.setFillColor(this.getBackColor());
        builder.setStrokeColor(this.getForeColor());
        Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
        builder.drawRectangle(frame, 5.0);
        builder.fillStroke();
        builder.end();
        String caption = (String)field.getValue();
        if (caption != null) {
            BlockFilter blockFilter = new BlockFilter(builder);
            blockFilter.begin(frame, AlignmentXEnum.Center, AlignmentYEnum.Middle);
            builder.setFillColor(this.getForeColor());
            builder.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.Helvetica, true, false), ((Dimension2D)size).getHeight() * 0.5);
            blockFilter.showText(caption);
            blockFilter.end();
        }
        builder.flush();
        appearance.getNormal().put(null, normalAppearanceState);
    }

    private void apply(TextField field) {
        Document document = field.getDocument();
        Widget widget = field.getWidgets().get(0);
        Appearance appearance = widget.getAppearance();
        if (appearance == null) {
            appearance = new Appearance(document);
            widget.setAppearance(appearance);
        }
        ((PdfDictionary)widget.getBaseDataObject()).put(PdfName.DA, new PdfString("/Helv " + this.getFontSize() + " Tf 0 0 0 rg"));
        FormXObject normalAppearanceState = new FormXObject(document);
        Rectangle2D widgetBox = widget.getBox();
        Dimension size = new Dimension(widgetBox.getWidth(), widgetBox.getHeight());
        normalAppearanceState.setSize(size);
        PrimitiveFilter builder = new PrimitiveFilter(normalAppearanceState);
        builder.beginLocalState();
        double lineWidth = 1.0;
        builder.setLineWidth(lineWidth);
        builder.setFillColor(this.getBackColor());
        builder.setStrokeColor(this.getForeColor());
        Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
        builder.drawRectangle(frame, 5.0);
        builder.fillStroke();
        builder.end();
        builder.beginMarkedContent(PdfName.Tx);
        builder.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.Helvetica, false, false), this.getFontSize());
        builder.showText((String)field.getValue(), new Point2D.Double(0.0, ((Dimension2D)size).getHeight() / 2.0), AlignmentXEnum.Left, AlignmentYEnum.Middle, 0.0);
        builder.end();
        builder.flush();
        appearance.getNormal().put(null, normalAppearanceState);
    }

    private void apply(ComboBox field) {
        Document document = field.getDocument();
        Widget widget = field.getWidgets().get(0);
        Appearance appearance = widget.getAppearance();
        if (appearance == null) {
            appearance = new Appearance(document);
            widget.setAppearance(appearance);
        }
        ((PdfDictionary)widget.getBaseDataObject()).put(PdfName.DA, new PdfString("/Helv " + this.getFontSize() + " Tf 0 0 0 rg"));
        FormXObject normalAppearanceState = new FormXObject(document);
        Rectangle2D widgetBox = widget.getBox();
        Dimension size = new Dimension(widgetBox.getWidth(), widgetBox.getHeight());
        normalAppearanceState.setSize(size);
        PrimitiveFilter builder = new PrimitiveFilter(normalAppearanceState);
        builder.beginLocalState();
        double lineWidth = 1.0;
        builder.setLineWidth(lineWidth);
        builder.setFillColor(this.getBackColor());
        builder.setStrokeColor(this.getForeColor());
        Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
        builder.drawRectangle(frame, 5.0);
        builder.fillStroke();
        builder.end();
        builder.beginMarkedContent(PdfName.Tx);
        builder.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.Helvetica, false, false), this.getFontSize());
        builder.showText((String)field.getValue(), new Point2D.Double(0.0, ((Dimension2D)size).getHeight() / 2.0), AlignmentXEnum.Left, AlignmentYEnum.Middle, 0.0);
        builder.end();
        builder.flush();
        appearance.getNormal().put(null, normalAppearanceState);
    }

    private void apply(ListBox field) {
        Document document = field.getDocument();
        Widget widget = field.getWidgets().get(0);
        Appearance appearance = widget.getAppearance();
        if (appearance == null) {
            appearance = new Appearance(document);
            widget.setAppearance(appearance);
        }
        PdfDictionary widgetDataObject = (PdfDictionary)widget.getBaseDataObject();
        widgetDataObject.put(PdfName.DA, new PdfString("/Helv " + this.getFontSize() + " Tf 0 0 0 rg"));
        widgetDataObject.put(PdfName.MK, new PdfDictionary(new PdfName[]{PdfName.BG, PdfName.BC}, new PdfDirectObject[]{new PdfArray(new PdfReal(0.9), new PdfReal(0.9), new PdfReal(0.9)), new PdfArray(new PdfInteger(0), new PdfInteger(0), new PdfInteger(0))}));
        FormXObject normalAppearanceState = new FormXObject(document);
        Rectangle2D widgetBox = widget.getBox();
        Dimension size = new Dimension(widgetBox.getWidth(), widgetBox.getHeight());
        normalAppearanceState.setSize(size);
        PrimitiveFilter builder = new PrimitiveFilter(normalAppearanceState);
        builder.beginLocalState();
        double lineWidth = 1.0;
        builder.setLineWidth(lineWidth);
        builder.setFillColor(this.getBackColor());
        builder.setStrokeColor(this.getForeColor());
        Rectangle2D.Double frame = new Rectangle2D.Double(lineWidth / 2.0, lineWidth / 2.0, ((Dimension2D)size).getWidth() - lineWidth, ((Dimension2D)size).getHeight() - lineWidth);
        builder.drawRectangle(frame, 5.0);
        builder.fillStroke();
        builder.end();
        builder.beginLocalState();
        builder.drawRectangle(frame, 5.0);
        builder.clip();
        builder.beginMarkedContent(PdfName.Tx);
        builder.setFont(new StandardType1Font(document, StandardType1Font.FamilyEnum.Helvetica, false, false), this.getFontSize());
        double y = 3.0;
        for (ChoiceItem item : field.getItems()) {
            builder.showText(item.getText(), new Point2D.Double(0.0, y));
            if ((y += this.getFontSize() * 1.175) > ((Dimension2D)size).getHeight()) break;
        }
        builder.end();
        builder.end();
        builder.flush();
        appearance.getNormal().put(null, normalAppearanceState);
    }
}

